/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.api;

import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.flow.DiscoveryFlow;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.discovery.client.flow.RegisterStateManager;
import com.tencent.polaris.discovery.client.util.Validator;

public class DefaultProviderAPI
extends BaseEngine
implements ProviderAPI {
    private DiscoveryFlow discoveryFlow;

    public DefaultProviderAPI(SDKContext sdkContext) {
        super(sdkContext);
    }

    @Override
    protected void subInit() {
        this.discoveryFlow = this.sdkContext.getOrInitFlow(DiscoveryFlow.class);
    }

    @Override
    public InstanceRegisterResponse registerInstance(InstanceRegisterRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceRegisterRequest(req);
        req.setAutoHeartbeat(true);
        return this.discoveryFlow.register(req);
    }

    @Override
    protected void doDestroy() {
        RegisterStateManager.destroy(this.sdkContext);
        super.doDestroy();
        if (this.discoveryFlow != null) {
            this.discoveryFlow.destroy();
        }
    }

    @Override
    public InstanceRegisterResponse register(InstanceRegisterRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceRegisterRequest(req);
        return this.discoveryFlow.register(req);
    }

    @Override
    public void deRegister(InstanceDeregisterRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceDeregisterRequest(req);
        this.discoveryFlow.deRegister(req);
    }

    @Override
    public void heartbeat(InstanceHeartbeatRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateHeartbeatRequest(req);
        this.discoveryFlow.heartbeat(req);
    }
}

