/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum ClickHouseProtocol {
    ANY(0, "anys"),
    HTTP(8123, 8443, "http", "https"),
    TCP(9000, 9440, "native", "tcp", "tcps"),
    MYSQL(9004, "mysql"),
    POSTGRESQL(9005, "postgres", "postgresql", "pgsql"),
    GRPC(9100, "grpc", "grpcs");

    private final int defaultPort;
    private final int defaultSecurePort;
    private final List<String> schemes;

    public static ClickHouseProtocol fromUriScheme(String scheme) {
        ClickHouseProtocol protocol = ANY;
        block0: for (ClickHouseProtocol p : ClickHouseProtocol.values()) {
            for (String s : p.getUriSchemes()) {
                if (!s.equalsIgnoreCase(scheme)) continue;
                protocol = p;
                continue block0;
            }
        }
        return protocol;
    }

    private ClickHouseProtocol(int defaultPort, String ... schemes) {
        this(defaultPort, defaultPort, schemes);
    }

    private ClickHouseProtocol(int defaultPort, int defaultSecurePort, String ... schemes) {
        int len;
        this.defaultPort = defaultPort;
        this.defaultSecurePort = defaultSecurePort;
        int n2 = len = schemes != null ? schemes.length : 0;
        if (len > 0) {
            ArrayList<String> list = new ArrayList<String>(len);
            for (String scheme : schemes) {
                if (scheme == null) continue;
                list.add(scheme);
            }
            this.schemes = Collections.unmodifiableList(list);
        } else {
            this.schemes = Collections.emptyList();
        }
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public int getDefaultSecurePort() {
        return this.defaultSecurePort;
    }

    public List<String> getUriSchemes() {
        return this.schemes;
    }
}

