/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.dubbo.common.utils.TypeUtils;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;
import org.apache.dubbo.metadata.definition.util.ClassUtils;

public class MapTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getCanonicalName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        int actualTypeArgsLength = actualTypeArgs == null ? 0 : actualTypeArgs.length;
        String mapType = ClassUtils.getCanonicalNameForParameterizedType(parameterizedType);
        TypeDefinition td = typeCache.get(mapType);
        if (td != null) {
            return td;
        }
        td = new TypeDefinition(mapType);
        typeCache.put(mapType, td);
        for (int i = 0; i < actualTypeArgsLength; ++i) {
            Type actualType = actualTypeArgs[i];
            TypeDefinition item = null;
            Class<?> rawType = TypeUtils.getRawClass(actualType);
            if (TypeUtils.isParameterizedType(actualType)) {
                item = TypeDefinitionBuilder.build(actualType, rawType, typeCache);
            } else if (TypeUtils.isClass(actualType)) {
                item = TypeDefinitionBuilder.build(null, rawType, typeCache);
            }
            if (item == null) continue;
            td.getItems().add(item.getType());
        }
        return td;
    }
}

