/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceKeyMetric
extends ApplicationMetric {
    private final String serviceKey;
    private volatile int hashCode = 0;

    public ServiceKeyMetric(ApplicationModel applicationModel, String serviceKey) {
        super(applicationModel);
        this.serviceKey = serviceKey;
    }

    @Override
    public Map<String, String> getTags() {
        return MetricsSupport.serviceTags(this.getApplicationModel(), this.serviceKey, this.getExtraInfo());
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceKeyMetric)) {
            return false;
        }
        ServiceKeyMetric that = (ServiceKeyMetric)o;
        return this.serviceKey.equals(that.serviceKey) && Objects.equals(this.extraInfo, that.extraInfo);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.getApplicationName(), this.serviceKey, this.extraInfo);
        }
        return this.hashCode;
    }

    public String toString() {
        return "ServiceKeyMetric{applicationName='" + this.getApplicationName() + '\'' + ", serviceKey='" + this.serviceKey + '\'' + '}';
    }
}

