/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.reactive.calls;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.reactive.ServerTripleReactorPublisher;
import org.apache.dubbo.reactive.ServerTripleReactorSubscriber;
import org.apache.dubbo.rpc.StatusRpcException;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.observer.ServerCallToObserverAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorServerCalls {
    private ReactorServerCalls() {
    }

    public static <T, R> void oneToOne(T request, StreamObserver<R> responseObserver, Function<Mono<T>, Mono<R>> func) {
        try {
            func.apply(Mono.just(request)).switchIfEmpty(Mono.error((Throwable)TriRpcStatus.NOT_FOUND.asException())).subscribe(responseObserver::onNext, throwable -> ReactorServerCalls.doOnResponseHasException(throwable, responseObserver), responseObserver::onCompleted);
        }
        catch (Throwable throwable2) {
            ReactorServerCalls.doOnResponseHasException(throwable2, responseObserver);
        }
    }

    public static <T, R> CompletableFuture<List<R>> oneToMany(T request, StreamObserver<R> responseObserver, Function<Mono<T>, Flux<R>> func) {
        try {
            ServerCallToObserverAdapter serverCallToObserverAdapter = (ServerCallToObserverAdapter)responseObserver;
            Flux<R> response = func.apply(Mono.just(request));
            ServerTripleReactorSubscriber reactorSubscriber = new ServerTripleReactorSubscriber(serverCallToObserverAdapter);
            ((ServerTripleReactorSubscriber)response.subscribeWith(reactorSubscriber)).subscribe(serverCallToObserverAdapter);
            return reactorSubscriber.getExecutionFuture();
        }
        catch (Throwable throwable) {
            ReactorServerCalls.doOnResponseHasException(throwable, responseObserver);
            CompletableFuture<List<R>> future = new CompletableFuture<List<R>>();
            future.completeExceptionally(throwable);
            return future;
        }
    }

    public static <T, R> StreamObserver<T> manyToOne(StreamObserver<R> responseObserver, Function<Flux<T>, Mono<R>> func) {
        ServerTripleReactorPublisher serverPublisher = new ServerTripleReactorPublisher((CallStreamObserver)responseObserver);
        try {
            Mono<R> responseMono = func.apply(Flux.from(serverPublisher));
            responseMono.subscribe(value -> {
                if (!serverPublisher.isCancelled()) {
                    responseObserver.onNext(value);
                }
            }, throwable -> {
                if (!serverPublisher.isCancelled()) {
                    responseObserver.onError((Throwable)throwable);
                }
            }, responseObserver::onCompleted);
            serverPublisher.startRequest();
        }
        catch (Throwable throwable2) {
            responseObserver.onError(throwable2);
        }
        return serverPublisher;
    }

    public static <T, R> StreamObserver<T> manyToMany(StreamObserver<R> responseObserver, Function<Flux<T>, Flux<R>> func) {
        ServerTripleReactorPublisher serverPublisher = new ServerTripleReactorPublisher((CallStreamObserver)responseObserver);
        try {
            Flux<R> responseFlux = func.apply(Flux.from(serverPublisher));
            ServerTripleReactorSubscriber serverSubscriber = (ServerTripleReactorSubscriber)responseFlux.subscribeWith(new ServerTripleReactorSubscriber());
            serverSubscriber.subscribe((CallStreamObserver)responseObserver);
            serverPublisher.startRequest();
        }
        catch (Throwable throwable) {
            responseObserver.onError(throwable);
        }
        return serverPublisher;
    }

    private static void doOnResponseHasException(Throwable throwable, StreamObserver<?> responseObserver) {
        StatusRpcException statusRpcException = TriRpcStatus.getStatus(throwable).asException();
        responseObserver.onError(statusRpcException);
    }
}

