/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.registry.integration.ServiceURLCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultServiceURLCustomizer
implements ServiceURLCustomizer {
    private static final String[] excludedParameters = new String[]{"monitor", "bind.ip", "bind.port", "qos.enable", "qos.host", "qos.port", "qos.accept.foreign.ip", "validation", "interfaces", "register-mode", "pid", "file-cache", "executor-management-mode", "background", "anyhost", "threadname", "threadpool", "alive", "queues", "corethreads", "threads"};

    @Override
    public URL customize(URL serviceURL, ApplicationModel applicationModel) {
        boolean simplified = (Boolean)serviceURL.getAttribute("simplified", false);
        if (simplified) {
            String extraKeys = (String)serviceURL.getAttribute("extra-keys", "");
            if (!serviceURL.getPath().equals(serviceURL.getParameter("interface"))) {
                if (StringUtils.isNotEmpty(extraKeys)) {
                    extraKeys = extraKeys + ",";
                }
                extraKeys = extraKeys + "interface";
            }
            String[] paramsToRegistry = (String[])Stream.concat(Arrays.stream(RegistryProtocol.DEFAULT_REGISTER_PROVIDER_KEYS), Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(extraKeys))).toArray(String[]::new);
            return URL.valueOf(serviceURL, paramsToRegistry, serviceURL.getParameter("methods", (String[])null));
        }
        return serviceURL.removeParameters(this.getFilteredKeys(serviceURL)).removeParameters(excludedParameters);
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    private String[] getFilteredKeys(URL url) {
        Map<String, String> params = url.getParameters();
        if (CollectionUtils.isNotEmptyMap(params)) {
            return (String[])params.keySet().stream().filter(k -> k.startsWith(".")).toArray(String[]::new);
        }
        return new String[0];
    }
}

