/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.jetty;

import javax.servlet.ServletContext;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.jetty.JettyLoggerAdapter;
import org.apache.dubbo.remoting.http.servlet.DispatcherServlet;
import org.apache.dubbo.remoting.http.servlet.ServletManager;
import org.apache.dubbo.remoting.http.support.AbstractHttpServer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyHttpServer
extends AbstractHttpServer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(JettyHttpServer.class);
    private Server server;
    private URL url;

    public JettyHttpServer(URL url, HttpHandler handler) {
        super(url, handler);
        this.url = url;
        System.setProperty("org.eclipse.jetty.util.log.class", JettyLoggerAdapter.class.getName());
        DispatcherServlet.addHttpHandler(url.getParameter("bind.port", url.getPort()), handler);
        int threads = url.getParameter("threads", 200);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        threadPool.setMaxThreads(threads);
        threadPool.setMinThreads(threads);
        this.server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        String bindIp = url.getParameter("bind.ip", url.getHost());
        if (!url.isAnyHost() && NetUtils.isValidLocalHost(bindIp)) {
            connector.setHost(bindIp);
        }
        connector.setPort(url.getParameter("bind.port", url.getPort()));
        this.server.addConnector((Connector)connector);
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder servletHolder = servletHandler.addServletWithMapping(DispatcherServlet.class, "/*");
        servletHolder.setInitOrder(2);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/", 1);
        context.setServletHandler(servletHandler);
        ServletManager.getInstance().addServletContext(url.getParameter("bind.port", url.getPort()), (ServletContext)context.getServletContext());
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start jetty server on " + url.getParameter("bind.ip") + ":" + url.getParameter("bind.port") + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        super.close();
        ServletManager.getInstance().removeServletContext(this.url.getParameter("bind.port", this.url.getPort()));
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.warn("0-11", "", "", e.getMessage(), e);
            }
        }
    }
}

