/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.listener;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.listener.ExporterChangeListener;
import org.apache.dubbo.rpc.listener.ExporterListenerAdapter;

public class InjvmExporterListener
extends ExporterListenerAdapter {
    private final Map<String, Set<ExporterChangeListener>> exporterChangeListeners = new ConcurrentHashMap<String, Set<ExporterChangeListener>>();
    private final Map<String, Exporter<?>> exporters = new ConcurrentHashMap();

    @Override
    public void exported(Exporter<?> exporter) throws RpcException {
        String serviceKey = exporter.getInvoker().getUrl().getServiceKey();
        this.exporters.putIfAbsent(serviceKey, exporter);
        Set<ExporterChangeListener> listeners = this.exporterChangeListeners.get(serviceKey);
        if (!CollectionUtils.isEmpty(listeners)) {
            for (ExporterChangeListener listener : listeners) {
                listener.onExporterChangeExport(exporter);
            }
        }
        super.exported(exporter);
    }

    @Override
    public void unexported(Exporter<?> exporter) throws RpcException {
        String serviceKey = exporter.getInvoker().getUrl().getServiceKey();
        this.exporters.remove(serviceKey, exporter);
        Set<ExporterChangeListener> listeners = this.exporterChangeListeners.get(serviceKey);
        if (!CollectionUtils.isEmpty(listeners)) {
            for (ExporterChangeListener listener : listeners) {
                listener.onExporterChangeUnExport(exporter);
            }
        }
        super.unexported(exporter);
    }

    public synchronized void addExporterChangeListener(ExporterChangeListener listener, String serviceKey) {
        this.exporterChangeListeners.putIfAbsent(serviceKey, new ConcurrentHashSet());
        this.exporterChangeListeners.get(serviceKey).add(listener);
        if (this.exporters.get(serviceKey) != null) {
            Exporter<?> exporter = this.exporters.get(serviceKey);
            listener.onExporterChangeExport(exporter);
        }
    }

    public synchronized void removeExporterChangeListener(ExporterChangeListener listener, String listenerKey) {
        Set<ExporterChangeListener> listeners = this.exporterChangeListeners.get(listenerKey);
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        listeners.remove(listener);
        if (CollectionUtils.isEmpty(listeners)) {
            this.exporterChangeListeners.remove(listenerKey);
        }
    }
}

