/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapConfiguration
extends AbstractConfiguration {
    protected ConcurrentHashMap<String, Object> map;
    private Collection<ConfigurationListener> listeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private Collection<ConfigurationErrorListener> errorListeners = new CopyOnWriteArrayList<ConfigurationErrorListener>();
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentMapConfiguration.class);
    private static final int NUM_LOCKS = 32;
    private ReentrantLock[] locks = new ReentrantLock[32];

    public ConcurrentMapConfiguration() {
        this.map = new ConcurrentHashMap();
        for (int i = 0; i < 32; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public ConcurrentMapConfiguration(Map<String, Object> map) {
        this();
        this.map = new ConcurrentHashMap<String, Object>(map);
    }

    public ConcurrentMapConfiguration(Configuration configuration) {
        this();
        Iterator iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = configuration.getProperty(string);
            this.map.put(string, object);
        }
    }

    public Object getProperty(String string) {
        return this.map.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPropertyDirect(String string, Object object) {
        ReentrantLock reentrantLock = this.locks[Math.abs(string.hashCode()) % 32];
        reentrantLock.lock();
        try {
            Object object2 = this.map.putIfAbsent(string, object);
            if (object2 == null) {
                return;
            }
            if (object2 instanceof List) {
                ((List)object2).add(object);
            } else {
                CopyOnWriteArrayList<Object> copyOnWriteArrayList = new CopyOnWriteArrayList<Object>();
                copyOnWriteArrayList.add(object2);
                copyOnWriteArrayList.add(object);
                this.map.put(string, copyOnWriteArrayList);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String string) {
        return this.map.containsKey(string);
    }

    protected void clearPropertyDirect(String string) {
        this.map.remove(string);
    }

    public Iterator getKeys() {
        return this.map.keySet().iterator();
    }

    private void addPropertyValues(String string, Object object, char c) {
        Iterator iterator = PropertyConverter.toIterator((Object)object, (char)c);
        while (iterator.hasNext()) {
            this.addPropertyDirect(string, iterator.next());
        }
    }

    public void addProperty(String string, Object object) {
        if (object == null) {
            throw new NullPointerException("Value for property " + string + " is null");
        }
        this.fireEvent(1, string, object, true);
        this.addPropertyImpl(string, object);
        this.fireEvent(1, string, object, false);
    }

    protected void addPropertyImpl(String string, Object object) {
        Object object2 = null;
        if (this.isDelimiterParsingDisabled() || object instanceof String && ((String)object).indexOf(this.getListDelimiter()) < 0) {
            object2 = this.map.putIfAbsent(string, object);
            if (object2 != null) {
                this.addPropertyValues(string, object, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
            }
        } else {
            this.addPropertyValues(string, object, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
        }
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            throw new NullPointerException("Value for property " + string + " is null");
        }
        this.fireEvent(3, string, object, true);
        this.setPropertyImpl(string, object);
        this.fireEvent(3, string, object, false);
    }

    protected void setPropertyImpl(String string, Object object) {
        if (this.isDelimiterParsingDisabled()) {
            this.map.put(string, object);
        } else if (object instanceof String && ((String)object).indexOf(this.getListDelimiter()) < 0) {
            this.map.put(string, object);
        } else {
            Iterator iterator = PropertyConverter.toIterator((Object)object, (char)this.getListDelimiter());
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            while (iterator.hasNext()) {
                copyOnWriteArrayList.add(iterator.next());
            }
            if (copyOnWriteArrayList.size() == 1) {
                this.map.put(string, copyOnWriteArrayList.get(0));
            } else {
                this.map.put(string, copyOnWriteArrayList);
            }
        }
    }

    public void loadProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            Object object = entry.getValue();
            if (string == null || object == null) continue;
            this.setProperty(string, object);
        }
    }

    public void copy(Configuration configuration) {
        if (configuration != null) {
            Iterator iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = configuration.getProperty(string);
                if (string == null || object == null) continue;
                this.setProperty(string, object);
            }
        }
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        this.map.clear();
        this.fireEvent(4, null, null, false);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Iterator iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getString(string);
            properties.put(string, string2);
        }
        return properties;
    }

    protected void fireEvent(int n, String string, Object object, boolean bl) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        ConfigurationEvent configurationEvent = this.createEvent(n, string, object, bl);
        for (ConfigurationListener configurationListener : this.listeners) {
            try {
                configurationListener.configurationChanged(configurationEvent);
            }
            catch (Throwable throwable) {
                logger.error("Error firing configuration event", throwable);
            }
        }
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        if (!this.listeners.contains(configurationListener)) {
            this.listeners.add(configurationListener);
        }
    }

    public void addErrorListener(ConfigurationErrorListener configurationErrorListener) {
        if (!this.errorListeners.contains(configurationErrorListener)) {
            this.errorListeners.add(configurationErrorListener);
        }
    }

    public void clearConfigurationListeners() {
        this.listeners.clear();
    }

    public void clearErrorListeners() {
        this.errorListeners.clear();
    }

    public Collection<ConfigurationListener> getConfigurationListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return Collections.unmodifiableCollection(this.errorListeners);
    }

    public boolean removeConfigurationListener(ConfigurationListener configurationListener) {
        return this.listeners.remove(configurationListener);
    }

    public boolean removeErrorListener(ConfigurationErrorListener configurationErrorListener) {
        return this.errorListeners.remove(configurationErrorListener);
    }

    protected void fireError(int n, String string, Object object, Throwable throwable) {
        if (this.errorListeners == null || this.errorListeners.size() == 0) {
            return;
        }
        ConfigurationErrorEvent configurationErrorEvent = this.createErrorEvent(n, string, object, throwable);
        for (ConfigurationErrorListener configurationErrorListener : this.errorListeners) {
            try {
                configurationErrorListener.configurationError(configurationErrorEvent);
            }
            catch (Throwable throwable2) {
                logger.error("Error firing configuration error event", throwable2);
            }
        }
    }
}

