/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign;

import java.util.List;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.exception.ResponsiveException;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.ServerWebExchangeUtils;
import org.apache.shenyu.plugin.sign.api.VerifyResult;
import org.apache.shenyu.plugin.sign.handler.SignPluginDataHandler;
import org.apache.shenyu.plugin.sign.handler.SignRuleHandler;
import org.apache.shenyu.plugin.sign.service.SignService;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SignPlugin
extends AbstractShenyuPlugin {
    private final List<HttpMessageReader<?>> messageReaders;
    private final SignService signService;

    public SignPlugin(List<HttpMessageReader<?>> readers, SignService signService) {
        this.signService = signService;
        this.messageReaders = readers;
    }

    public String named() {
        return PluginEnum.SIGN.getName();
    }

    public int getOrder() {
        return PluginEnum.SIGN.getCode();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selectorData, RuleData rule) {
        SignRuleHandler ruleHandler = (SignRuleHandler)SignPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (ObjectUtils.isEmpty((Object)ruleHandler) || !ruleHandler.getSignRequestBody()) {
            VerifyResult result = this.signService.signatureVerify(exchange);
            if (result.isFailed()) {
                return WebFluxResultUtils.failedResult((int)ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), (String)result.getReason(), (ServerWebExchange)exchange);
            }
            return chain.execute(exchange);
        }
        return ServerWebExchangeUtils.rewriteRequestBody((ServerWebExchange)exchange, this.messageReaders, body -> {
            VerifyResult result = this.signVerifyWithBody((String)body, exchange);
            if (result.isSuccess()) {
                return Mono.just((Object)body);
            }
            throw new ResponsiveException(ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), result.getReason(), exchange);
        }).flatMap(arg_0 -> ((ShenyuPluginChain)chain).execute(arg_0)).onErrorResume(error -> {
            if (error instanceof ResponsiveException) {
                return WebFluxResultUtils.failedResult((ResponsiveException)((ResponsiveException)error));
            }
            return Mono.error((Throwable)error);
        });
    }

    private VerifyResult signVerifyWithBody(String originalBody, ServerWebExchange exchange) {
        return this.signService.signatureVerify(exchange, originalBody);
    }
}

