/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.util.http.CasdoorResponse;
import org.casbin.casdoor.util.http.HttpClient;

public class CasdoorAccountService {
    private final CasdoorConfig casdoorConfig;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CasdoorAccountService(CasdoorConfig casdoorConfig) {
        this.casdoorConfig = casdoorConfig;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public CasdoorResponse setPassword(String userName, String oldPassword, String newPassword) throws IOException {
        String targetUrl = String.format("%s/api/set-password?owner=%s&clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        HashMap<String, String> formData = new HashMap<String, String>(4);
        formData.put("userOwner", this.casdoorConfig.getOrganizationName());
        formData.put("userName", userName);
        formData.put("oldPassword", oldPassword);
        formData.put("newPassword", newPassword);
        String responseStr = HttpClient.postForm(targetUrl, formData);
        return (CasdoorResponse)this.objectMapper.readValue(responseStr, CasdoorResponse.class);
    }
}

