/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.util;

import com.tencentcloudapi.cls.producer.util.DigestUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class QcloudClsSignature {
    public static final String LINE_SEPARATOR = "\n";
    public static final String Q_SIGN_ALGORITHM_KEY = "q-sign-algorithm";
    public static final String Q_SIGN_ALGORITHM_VALUE = "sha1";
    public static final String Q_AK = "q-ak";
    public static final String Q_SIGN_TIME = "q-sign-time";
    public static final String Q_KEY_TIME = "q-key-time";
    public static final String Q_HEADER_LIST = "q-header-list";
    public static final String Q_URL_PARAM_LIST = "q-url-param-list";
    public static final String Q_SIGNATURE = "q-signature";
    public static final String DEFAULT_ENCODING = "UTF-8";

    private static Map<String, String> buildSignHeaders(Map<String, String> originHeaders) {
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> headerEntry : originHeaders.entrySet()) {
            String key = headerEntry.getKey();
            if (!key.equalsIgnoreCase("content-type") && !key.equalsIgnoreCase("content-md5") && !key.equalsIgnoreCase("host") && !key.startsWith("x") && !key.startsWith("X")) continue;
            String lowerKey = key.toLowerCase();
            String value = headerEntry.getValue();
            signHeaders.put(lowerKey, value);
        }
        return signHeaders;
    }

    private static String buildSignMemberStr(Map<String, String> signHeaders) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seenOne = false;
        for (String key : signHeaders.keySet()) {
            if (!seenOne) {
                seenOne = true;
            } else {
                strBuilder.append(";");
            }
            strBuilder.append(key.toLowerCase());
        }
        return strBuilder.toString();
    }

    private static String formatMapToStr(Map<String, String> kVMap) throws UnsupportedEncodingException {
        StringBuilder strBuilder = new StringBuilder();
        boolean seeOne = false;
        for (Map.Entry<String, String> entry : kVMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String lowerKey = key.toLowerCase();
            String encodeKey = URLEncoder.encode(lowerKey, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            String encodedValue = "";
            if (value != null) {
                encodedValue = URLEncoder.encode(value, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            }
            if (!seeOne) {
                seeOne = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(encodeKey).append("=").append(encodedValue);
        }
        return strBuilder.toString();
    }

    private static String buildTimeStr(long expireMillsecond) {
        StringBuilder strBuilder = new StringBuilder();
        long startTime = System.currentTimeMillis() / 1000L - 60L;
        long endTime = (System.currentTimeMillis() + expireMillsecond) / 1000L;
        strBuilder.append(startTime).append(";").append(endTime);
        return strBuilder.toString();
    }

    public static String buildSignature(String secretId, String secretKey, String method, String path, Map<String, String> paramMap, Map<String, String> headerMap, long expireMillsecond) throws UnsupportedEncodingException {
        String qSignTimeStr;
        Map<String, String> signHeaders = QcloudClsSignature.buildSignHeaders(headerMap);
        TreeMap<String, String> sortedSignHeaders = new TreeMap<String, String>();
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        sortedSignHeaders.putAll(signHeaders);
        sortedParams.putAll(paramMap);
        String qHeaderListStr = QcloudClsSignature.buildSignMemberStr(sortedSignHeaders);
        String qUrlParamListStr = QcloudClsSignature.buildSignMemberStr(sortedParams);
        String qKeyTimeStr = qSignTimeStr = QcloudClsSignature.buildTimeStr(expireMillsecond);
        String signKey = DigestUtils.hamcSha1(qKeyTimeStr.getBytes(), secretKey.getBytes());
        String formatMethod = method.toLowerCase();
        String formatParameters = QcloudClsSignature.formatMapToStr(sortedParams);
        String formatHeaders = QcloudClsSignature.formatMapToStr(sortedSignHeaders);
        String formatStr = formatMethod + LINE_SEPARATOR + path + LINE_SEPARATOR + formatParameters + LINE_SEPARATOR + formatHeaders + LINE_SEPARATOR;
        String hashFormatStr = DigestUtils.sha1(formatStr);
        String stringToSign = "sha1\n" + qSignTimeStr + LINE_SEPARATOR + hashFormatStr + LINE_SEPARATOR;
        String signature = DigestUtils.hamcSha1(stringToSign.getBytes(), signKey.getBytes());
        return "q-sign-algorithm=sha1&q-ak=" + secretId + "&" + Q_SIGN_TIME + "=" + qSignTimeStr + "&" + Q_KEY_TIME + "=" + qKeyTimeStr + "&" + Q_HEADER_LIST + "=" + qHeaderListStr + "&" + Q_URL_PARAM_LIST + "=" + qUrlParamListStr + "&" + Q_SIGNATURE + "=" + signature;
    }
}

