/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.BaseData;
import org.apache.shenyu.common.dto.ConditionData;

public class RuleData
extends BaseData {
    private String pluginName;
    private String selectorId;
    private Integer matchMode;
    private Boolean loged;
    private String handle;
    private List<ConditionData> conditionDataList;
    private List<ConditionData> beforeConditionDataList;
    private Boolean matchRestful;

    public RuleData() {
    }

    private RuleData(Builder builder) {
        this.setId(builder.id);
        this.setName(builder.name);
        this.pluginName = builder.pluginName;
        this.selectorId = builder.selectorId;
        this.matchMode = builder.matchMode;
        this.setSort(builder.sort);
        this.setEnabled(builder.enabled);
        this.loged = builder.loged;
        this.handle = builder.handle;
        this.conditionDataList = builder.conditionDataList;
        this.beforeConditionDataList = builder.beforeConditionDataList;
        this.matchRestful = builder.matchRestful;
        this.setNamespaceId(builder.namespaceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public RuleData setPluginName(String pluginName) {
        this.pluginName = pluginName;
        return this;
    }

    @Override
    public RuleData setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public RuleData setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public RuleData setSort(Integer sort) {
        super.setSort(sort);
        return this;
    }

    @Override
    public RuleData setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public RuleData setNamespaceId(String namespaceId) {
        super.setNamespaceId(namespaceId);
        return this;
    }

    public String getSelectorId() {
        return this.selectorId;
    }

    public RuleData setSelectorId(String selectorId) {
        this.selectorId = selectorId;
        return this;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public RuleData setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
        return this;
    }

    public Boolean getLoged() {
        return this.loged;
    }

    public RuleData setLoged(Boolean loged) {
        this.loged = loged;
        return this;
    }

    public String getHandle() {
        return this.handle;
    }

    public RuleData setHandle(String handle) {
        this.handle = handle;
        return this;
    }

    public List<ConditionData> getConditionDataList() {
        return this.conditionDataList;
    }

    public RuleData setConditionDataList(List<ConditionData> conditionDataList) {
        this.conditionDataList = conditionDataList;
        return this;
    }

    public List<ConditionData> getBeforeConditionDataList() {
        return this.beforeConditionDataList;
    }

    public void setBeforeConditionDataList(List<ConditionData> beforeConditionDataList) {
        this.beforeConditionDataList = beforeConditionDataList;
    }

    public Boolean getMatchRestful() {
        return this.matchRestful;
    }

    public void setMatchRestful(Boolean matchRestful) {
        this.matchRestful = matchRestful;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        RuleData ruleData = (RuleData)o;
        return Objects.equals(this.getId(), ruleData.getId()) && Objects.equals(this.getName(), ruleData.getName()) && Objects.equals(this.pluginName, ruleData.pluginName) && Objects.equals(this.selectorId, ruleData.selectorId) && Objects.equals(this.matchMode, ruleData.matchMode) && Objects.equals(this.getSort(), ruleData.getSort()) && Objects.equals(this.getEnabled(), ruleData.getEnabled()) && Objects.equals(this.loged, ruleData.loged) && Objects.equals(this.handle, ruleData.handle) && Objects.equals(this.conditionDataList, ruleData.conditionDataList) && Objects.equals(this.beforeConditionDataList, ruleData.beforeConditionDataList) && Objects.equals(this.matchRestful, ruleData.matchRestful) && Objects.equals(this.getNamespaceId(), ruleData.getNamespaceId());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.pluginName, this.selectorId, this.matchMode, this.getSort(), this.getEnabled(), this.loged, this.handle, this.conditionDataList, this.beforeConditionDataList, this.matchRestful, this.getNamespaceId());
    }

    public String toString() {
        return "RuleData{id='" + this.getId() + "', name='" + this.getName() + "', pluginName='" + this.pluginName + "', selectorId='" + this.selectorId + "', matchMode=" + this.matchMode + ", sort=" + this.getSort() + ", enabled=" + this.getEnabled() + ", loged=" + this.loged + ", handle='" + this.handle + "', conditionDataList=" + this.conditionDataList + ", matchRestful=" + this.matchRestful + "}";
    }

    public static final class Builder {
        private String id;
        private String name;
        private String pluginName;
        private String selectorId;
        private Integer matchMode;
        private Integer sort;
        private Boolean enabled;
        private Boolean loged;
        private String handle;
        private List<ConditionData> conditionDataList;
        private List<ConditionData> beforeConditionDataList;
        private Boolean matchRestful;
        private String namespaceId;

        private Builder() {
        }

        public RuleData build() {
            return new RuleData(this);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder selectorId(String selectorId) {
            this.selectorId = selectorId;
            return this;
        }

        public Builder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public Builder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder loged(Boolean loged) {
            this.loged = loged;
            return this;
        }

        public Builder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public Builder conditionDataList(List<ConditionData> conditionDataList) {
            this.conditionDataList = conditionDataList;
            return this;
        }

        public Builder beforeConditionDataList(List<ConditionData> beforeConditionDataList) {
            this.beforeConditionDataList = beforeConditionDataList;
            return this;
        }

        public Builder matchRestful(Boolean matchRestful) {
            this.matchRestful = matchRestful;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }
    }
}

