/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.message;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.message.Message;
import com.weibo.breeze.message.Schema;
import java.util.HashMap;
import java.util.Map;

public class GenericMessage
implements Message {
    private Map<Integer, Object> fields = new HashMap<Integer, Object>();
    private Schema schema;
    private String name = "GenericMessage";
    private String alias;

    public int getSize() {
        return this.fields.size();
    }

    public Object getFieldByIndex(int index) {
        return this.fields.get(index);
    }

    public Object getFieldByName(String name) throws BreezeException {
        if (this.schema == null) {
            throw new BreezeException("without schema");
        }
        Schema.Field field = this.schema.getFieldByName(name);
        if (field != null) {
            return this.fields.get(field.getIndex());
        }
        return null;
    }

    @Override
    public void writeToBuf(BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.writeMessage(buffer, () -> {
            for (Map.Entry<Integer, Object> entry : this.fields.entrySet()) {
                if (entry.getValue() == null) continue;
                buffer.putVarint(entry.getKey().intValue());
                BreezeWriter.writeObject(buffer, entry.getValue());
            }
        });
    }

    @Override
    public GenericMessage readFromBuf(BreezeBuffer buffer) throws BreezeException {
        BreezeReader.readMessage(buffer, index -> this.fields.put(index, BreezeReader.readObject(buffer, Object.class)));
        return this;
    }

    public Map<Integer, Object> getFields() {
        return this.fields;
    }

    @Override
    public String messageName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String messageAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Message defaultInstance() {
        return new GenericMessage();
    }

    public void putFields(Integer index, Object field) {
        this.fields.put(index, field);
    }
}

