/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.executor;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shenyu.common.dto.convert.rule.RateLimiterHandle;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ratelimiter.algorithm.RateLimiterAlgorithm;
import org.apache.shenyu.plugin.ratelimiter.algorithm.RateLimiterAlgorithmFactory;
import org.apache.shenyu.plugin.ratelimiter.response.RateLimiterResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(RedisRateLimiter.class);

    public Mono<RateLimiterResponse> isAllowed(String id, RateLimiterHandle limiterHandle) {
        double replenishRate = limiterHandle.getReplenishRate();
        double burstCapacity = limiterHandle.getBurstCapacity();
        double requestCount = limiterHandle.getRequestCount();
        RateLimiterAlgorithm<?> rateLimiterAlgorithm = RateLimiterAlgorithmFactory.newInstance(limiterHandle.getAlgorithmName());
        RedisScript<?> script = rateLimiterAlgorithm.getScript();
        List<String> keys = rateLimiterAlgorithm.getKeys(id);
        List scriptArgs = Stream.of(replenishRate, burstCapacity, Instant.now().getEpochSecond(), requestCount).map(x$0 -> String.valueOf(x$0)).collect(Collectors.toList());
        Flux resultFlux = ((ReactiveRedisTemplate)Singleton.INST.get(ReactiveRedisTemplate.class)).execute(script, keys, scriptArgs);
        return resultFlux.onErrorResume(throwable -> Flux.just(Arrays.asList(1L, -1L))).reduce(new ArrayList(), (longs, l) -> {
            longs.addAll(l);
            return longs;
        }).map(results -> {
            boolean allowed = ((Number)results.get(0)).longValue() == 1L;
            long tokensLeft = ((Number)results.get(1)).longValue();
            return new RateLimiterResponse(allowed, tokensLeft, keys);
        }).doOnError(throwable -> {
            rateLimiterAlgorithm.callback(rateLimiterAlgorithm.getScript(), keys, scriptArgs);
            LOG.error("Error occurred while judging if user is allowed by RedisRateLimiter:{}", (Object)throwable.getMessage());
        });
    }
}

