/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.multicast;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import java.net.Inet4Address;
import java.net.InetAddress;

public class MulticastRegistryHelper
extends RegistryUtils {
    public static void checkMulticastAddress(InetAddress multicastAddress) {
        if (!multicastAddress.isMulticastAddress()) {
            String message = "Invalid multicast address " + multicastAddress;
            if (multicastAddress instanceof Inet4Address) {
                throw new IllegalArgumentException(message + ", ipv4 multicast address scope: 224.0.0.0 - 239.255.255.255.");
            }
            throw new IllegalArgumentException(message + ", ipv6 multicast address must start with ff, for example: ff01::1");
        }
    }

    public static String buildListDataId(AbstractInterfaceConfig config, String protocol) {
        if ("bolt".equals(protocol) || "tr".equals(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(config) + "@DEFAULT";
        }
        return ConfigUniqueNameGenerator.getUniqueName(config) + "@" + protocol;
    }

    public static ProviderInfo convertProviderToProviderInfo(ProviderConfig config, ServerConfig server) {
        ProviderInfo providerInfo = new ProviderInfo().setPort(server.getPort()).setWeight(config.getWeight()).setSerializationType(config.getSerialization()).setProtocolType(server.getProtocol()).setPath(server.getContextPath()).setStaticAttrs(config.getParameters());
        String host = server.getHost();
        if (NetUtils.isLocalHost(host) || NetUtils.isAnyHost(host)) {
            host = SystemInfo.getLocalHost();
        }
        providerInfo.setHost(host);
        return providerInfo;
    }
}

