/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class ConditionExpression {
    private String expressionType;
    private List<String> attributes = new ArrayList<String>();
    private String value;
    private List<String> values;
    private boolean number;
    private String castType;

    public ConditionExpression(String expressionType, String attributes, String value) {
        this.expressionType = expressionType;
        this.attributes = Arrays.asList(attributes.split("\\."));
        this.value = value;
    }

    public void addValue(String value) {
        if (this.values != null) {
            this.values.add(value);
        } else {
            this.value = value;
        }
    }

    public void isNumber() {
        this.number = true;
    }

    public void enterMultiConditionValue() {
        this.values = new LinkedList<String>();
    }

    public void exitMultiConditionValue() {
        this.value = this.number ? "new long[]{" + String.join((CharSequence)",", this.values) + "}" : "new Object[]{" + String.join((CharSequence)",", this.values) + "}";
    }

    @Generated
    public String getExpressionType() {
        return this.expressionType;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public List<String> getValues() {
        return this.values;
    }

    @Generated
    public String getCastType() {
        return this.castType;
    }

    @Generated
    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }

    @Generated
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setValues(List<String> values) {
        this.values = values;
    }

    @Generated
    public void setNumber(boolean number) {
        this.number = number;
    }

    @Generated
    public void setCastType(String castType) {
        this.castType = castType;
    }

    @Generated
    public ConditionExpression() {
    }
}

