/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.RefType;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListenerFactory;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EntryAnalysisListener;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.NetworkAddressAliasSetup;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressAliasMappingListener
implements EntryAnalysisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAddressAliasMappingListener.class);
    private final SourceReceiver sourceReceiver;
    private final AnalyzerModuleConfig config;
    private final NamingControl namingControl;

    @Override
    public void parseEntry(SpanObject span, SegmentObject segmentObject) {
        if (span.getSkipAnalysis()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("service instance mapping listener parse reference");
        }
        if (!span.getSpanLayer().equals((Object)SpanLayer.MQ)) {
            span.getRefsList().forEach(segmentReference -> {
                if (RefType.CrossProcess.equals((Object)segmentReference.getRefType())) {
                    String networkAddressUsedAtPeer = this.namingControl.formatServiceName(segmentReference.getNetworkAddressUsedAtPeer());
                    if (this.config.getUninstrumentedGatewaysConfig().isAddressConfiguredAsGateway(networkAddressUsedAtPeer)) {
                        return;
                    }
                    String serviceName = this.namingControl.formatServiceName(segmentObject.getService());
                    String instanceName = this.namingControl.formatInstanceName(segmentObject.getServiceInstance());
                    NetworkAddressAliasSetup networkAddressAliasSetup = new NetworkAddressAliasSetup();
                    networkAddressAliasSetup.setAddress(networkAddressUsedAtPeer);
                    networkAddressAliasSetup.setRepresentService(serviceName);
                    networkAddressAliasSetup.setRepresentServiceNormal(true);
                    networkAddressAliasSetup.setRepresentServiceInstance(instanceName);
                    networkAddressAliasSetup.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)span.getStartTime()));
                    this.sourceReceiver.receive((ISource)networkAddressAliasSetup);
                }
            });
        }
    }

    @Override
    public void build() {
    }

    @Override
    public boolean containsPoint(AnalysisListener.Point point) {
        return AnalysisListener.Point.Entry.equals((Object)point);
    }

    @Generated
    public NetworkAddressAliasMappingListener(SourceReceiver sourceReceiver, AnalyzerModuleConfig config, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.config = config;
        this.namingControl = namingControl;
    }

    public static class Factory
    implements AnalysisListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public AnalysisListener create(ModuleManager moduleManager, AnalyzerModuleConfig config) {
            return new NetworkAddressAliasMappingListener(this.sourceReceiver, config, this.namingControl);
        }
    }
}

