/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.DefaultValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="labelAvg")
public abstract class LabelAvgMetrics
extends Metrics
implements LabeledValueHolder {
    protected static final String SUMMATION = "datatable_summation";
    protected static final String COUNT = "datatable_count";
    protected static final String VALUE = "datatable_value";
    protected static final String LABEL_NAME = "n";
    @Column(name="datatable_summation", storageOnly=true)
    @BanyanDB.MeasureField
    protected DataTable summation = new DataTable(30);
    @Column(name="datatable_count", storageOnly=true)
    @BanyanDB.MeasureField
    protected DataTable count = new DataTable(30);
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable value = new DataTable(30);
    private boolean isCalculated;
    private int maxLabelCount;

    @Entrance
    public final void combine(@Arg String label, @Arg long count, @DefaultValue(value="50") int maxLabelCount) {
        this.isCalculated = false;
        this.maxLabelCount = maxLabelCount;
        this.summation.valueAccumulation(label, count, maxLabelCount);
        this.count.valueAccumulation(label, 1L, maxLabelCount);
    }

    @Override
    public boolean combine(Metrics metrics) {
        this.isCalculated = false;
        LabelAvgMetrics labelCountMetrics = (LabelAvgMetrics)metrics;
        this.summation.append(labelCountMetrics.summation, labelCountMetrics.maxLabelCount);
        this.count.append(labelCountMetrics.count, labelCountMetrics.maxLabelCount);
        return true;
    }

    @Override
    public void calculate() {
        if (this.isCalculated) {
            return;
        }
        Set<String> keys = this.count.keys();
        for (String key : keys) {
            Long c;
            Long s = this.summation.get(key);
            if (Objects.isNull(s) || Objects.isNull(c = this.count.get(key))) continue;
            long result = s / c;
            if (result == 0L && s > 0L) {
                result = 1L;
            }
            DataLabel label = new DataLabel();
            label.put(LABEL_NAME, key);
            this.value.put(label, (Long)result);
        }
    }

    @Override
    public DataTable getValue() {
        return this.value;
    }

    @Generated
    public DataTable getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(DataTable summation) {
        this.summation = summation;
    }

    @Generated
    public DataTable getCount() {
        return this.count;
    }

    @Generated
    public void setCount(DataTable count) {
        this.count = count;
    }

    @Generated
    public void setValue(DataTable value) {
        this.value = value;
    }
}

