/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ElasticSearchConverter {
    private static String getPhysicalColumnName(String modelName, String fieldName) {
        return IndexController.LogicIndicesRegister.getPhysicalColumnName(modelName, fieldName);
    }

    public static class ToStorage
    implements Convert2Storage<Map<String, Object>> {
        private Map<String, Object> source = new HashMap<String, Object>();
        private String modelName;

        public ToStorage(String modelName) {
            this.modelName = modelName;
        }

        public void accept(String fieldName, Object fieldValue) {
            this.source.put(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName), fieldValue);
        }

        public void accept(String fieldName, byte[] fieldValue) {
            if (CollectionUtils.isEmpty((byte[])fieldValue)) {
                this.source.put(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName), "");
            } else {
                this.source.put(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName), new String(Base64.getEncoder().encode(fieldValue)));
            }
        }

        public void accept(String fieldName, List<String> fieldValue) {
            this.accept(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName), (Object)fieldValue);
        }

        public Object get(String fieldName) {
            return this.source.get(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName));
        }

        public Map<String, Object> obtain() {
            return this.source;
        }
    }

    public static class ToEntity
    implements Convert2Entity {
        private final String modelName;
        private final Map<String, Object> source;

        public Object get(String fieldName) {
            return this.source.get(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName));
        }

        public byte[] getBytes(String fieldName) {
            String value = (String)this.source.get(ElasticSearchConverter.getPhysicalColumnName(this.modelName, fieldName));
            if (StringUtil.isEmpty((String)value)) {
                return new byte[0];
            }
            return Base64.getDecoder().decode(value);
        }

        @Generated
        public ToEntity(String modelName, Map<String, Object> source) {
            this.modelName = modelName;
            this.source = source;
        }
    }
}

