/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.BlockingWebClient;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.DefaultBlockingWebClient;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpPreClient;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.RestClient;
import com.linecorp.armeria.client.UserClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.RequestTargetForm;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.ClientUtil;
import com.linecorp.armeria.internal.client.DefaultClientRequestContext;
import com.linecorp.armeria.internal.client.TailPreClient;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;

final class DefaultWebClient
extends UserClient<HttpRequest, HttpResponse>
implements WebClient {
    static final WebClient DEFAULT = new WebClientBuilder().build();
    static final RequestOptions RESPONSE_STREAMING_REQUEST_OPTIONS = RequestOptions.builder().exchangeType(ExchangeType.RESPONSE_STREAMING).build();
    @Nullable
    private BlockingWebClient blockingWebClient;
    @Nullable
    private RestClient restClient;
    private final HttpPreClient preClient;

    DefaultWebClient(ClientBuilderParams params, HttpClient delegate, MeterRegistry meterRegistry) {
        super(params, delegate, meterRegistry, HttpResponse::of, (ctx, cause) -> HttpResponse.ofFailure(cause));
        HttpPreClient tailPreClient = TailPreClient.of(this.unwrap(), this.futureConverter(), this.errorResponseFactory());
        this.preClient = this.options().clientPreprocessors().decorate(tailPreClient);
    }

    @Override
    public HttpResponse execute(HttpRequest req, RequestOptions requestOptions) {
        String newPath;
        SessionProtocol protocol;
        EndpointGroup endpointGroup;
        Objects.requireNonNull(req, "req");
        Objects.requireNonNull(requestOptions, "requestOptions");
        String originalPath = req.path();
        String prefix = Strings.emptyToNull(this.uri().getRawPath());
        RequestTarget reqTarget = RequestTarget.forClient(originalPath, prefix);
        if (reqTarget == null) {
            return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Invalid request target: " + originalPath));
        }
        if (Clients.isUndefinedUri(this.uri())) {
            String authority;
            String scheme;
            if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
                scheme = reqTarget.scheme();
                authority = reqTarget.authority();
                assert (scheme != null);
                assert (authority != null);
            } else {
                scheme = req.scheme();
                authority = req.authority();
                if (scheme == null || authority == null) {
                    return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Scheme and authority must be specified in \":path\" or in \":scheme\" and \":authority\". :path=" + originalPath + ", :scheme=" + req.scheme() + ", :authority=" + req.authority()));
                }
            }
            endpointGroup = Endpoint.parse(authority);
            try {
                protocol = Scheme.parse(scheme).sessionProtocol();
            }
            catch (Exception e) {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Failed to parse a scheme: " + reqTarget.scheme(), e));
            }
        } else {
            if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Cannot send a request with a \":path\" header that contains an authority, because the client was created with a base URI. path: " + originalPath));
            }
            endpointGroup = this.endpointGroup();
            protocol = this.scheme().sessionProtocol();
        }
        HttpRequest newReq = (newPath = reqTarget.pathAndQuery()).equals(originalPath) ? req : req.withHeaders(req.headers().toBuilder().path(newPath));
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(protocol, newReq, newReq.method(), null, reqTarget, endpointGroup, requestOptions, this.options(), this.meterRegistry());
        return (HttpResponse)ClientUtil.executeWithFallback(this.preClient, ctx, newReq, this.errorResponseFactory());
    }

    private static HttpResponse abortRequestAndReturnFailureResponse(HttpRequest req, IllegalArgumentException cause) {
        req.abort(cause);
        return HttpResponse.ofFailure(cause);
    }

    @Override
    public BlockingWebClient blocking() {
        if (this.blockingWebClient != null) {
            return this.blockingWebClient;
        }
        this.blockingWebClient = new DefaultBlockingWebClient(this);
        return this.blockingWebClient;
    }

    @Override
    public RestClient asRestClient() {
        if (this.restClient != null) {
            return this.restClient;
        }
        this.restClient = RestClient.of(this);
        return this.restClient;
    }

    @Override
    public HttpClient unwrap() {
        return (HttpClient)super.unwrap();
    }
}

