/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttp2ConnectionHandler.class);
    private static final Pattern IGNORABLE_HTTP2_ERROR_MESSAGE_GOAWAY = Pattern.compile("Stream (\\d+) does not exist", 2);
    private static final Http2StreamVisitor closeAllStreams = stream -> {
        if (stream.state() != Http2Stream.State.CLOSED) {
            stream.close();
        }
        return true;
    };
    private final KeepAliveHandler keepAliveHandler;
    private boolean closing;
    private boolean handlingConnectionError;
    private ByteBuf goAwayDebugData = Unpooled.EMPTY_BUFFER;

    protected AbstractHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, KeepAliveHandler keepAliveHandler) {
        super(decoder, encoder, initialSettings);
        this.keepAliveHandler = keepAliveHandler;
    }

    public final KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    public final boolean isClosing() {
        return this.closing;
    }

    @Override
    protected final void onConnectionError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception http2Ex) {
        if (this.handlingConnectionError) {
            return;
        }
        this.handlingConnectionError = true;
        if (Exceptions.isExpected(cause) || AbstractHttp2ConnectionHandler.isGoAwaySentException(cause, this.connection())) {
            logger.trace("{} HTTP/2 connection error:", (Object)ctx.channel(), (Object)cause);
        } else {
            logger.warn("{} HTTP/2 connection error:", (Object)ctx.channel(), (Object)cause);
        }
        super.onConnectionError(ctx, outbound, cause, AbstractHttp2ConnectionHandler.filterHttp2Exception(cause, http2Ex));
    }

    @Override
    protected void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        logger.debug("{} HTTP/2 stream error:", (Object)ctx.channel(), (Object)cause);
        super.onStreamError(ctx, outbound, cause, http2Ex);
    }

    private static Http2Exception filterHttp2Exception(Throwable cause, @Nullable Http2Exception http2Ex) {
        if (http2Ex != null) {
            return http2Ex;
        }
        return new Http2Exception(Http2Error.INTERNAL_ERROR, null, cause);
    }

    static boolean isGoAwaySentException(Throwable cause, Http2Connection connection) {
        if (!(cause instanceof Http2Exception)) {
            return false;
        }
        Http2Exception http2Exception = (Http2Exception)cause;
        if (http2Exception.error() != Http2Error.PROTOCOL_ERROR) {
            return false;
        }
        if (!connection.goAwaySent()) {
            return false;
        }
        String msg = cause.getMessage();
        Matcher matcher = IGNORABLE_HTTP2_ERROR_MESSAGE_GOAWAY.matcher(msg);
        if (!matcher.find()) {
            return false;
        }
        int streamId = Integer.parseInt(matcher.group(1));
        Http2Connection.Endpoint<Http2RemoteFlowController> remote = connection.remote();
        return remote.isValidStreamId(streamId) && streamId > remote.lastStreamKnownByPeer();
    }

    @Override
    public final ChannelFuture goAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        if (!ctx.channel().isActive()) {
            promise.unvoid().trySuccess();
            debugData.release();
            return promise;
        }
        return super.goAway(ctx, lastStreamId, errorCode, debugData, promise);
    }

    protected final ChannelFuture goAway(ChannelHandlerContext ctx, int lastStreamId) {
        return this.goAway(ctx, lastStreamId, Http2Error.NO_ERROR.code(), this.goAwayDebugData, ctx.newPromise());
    }

    protected final void setGoAwayDebugMessage(String debugMessage) {
        this.goAwayDebugData = Unpooled.unreleasableBuffer(Unpooled.copiedBuffer(debugMessage, StandardCharsets.UTF_8));
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (!this.closing) {
            this.closing = true;
            if (this.needsImmediateDisconnection()) {
                this.connection().forEachActiveStream(closeAllStreams);
            }
        }
        this.goAway(ctx, this.connection().remote().lastStreamCreated()).addListener(future -> super.close(ctx, promise));
        ctx.flush();
    }

    protected abstract boolean needsImmediateDisconnection();
}

