/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.common.metric.AbstractCloseableMeterBinder;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.metric.MicrometerUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class EventLoopMetrics
extends AbstractCloseableMeterBinder {
    private final EventLoopGroup eventLoopGroup;
    private final MeterIdPrefix idPrefix;

    EventLoopMetrics(EventLoopGroup eventLoopGroup, MeterIdPrefix idPrefix) {
        this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        this.idPrefix = idPrefix;
    }

    public void bindTo(MeterRegistry registry) {
        Self metrics = MicrometerUtil.register(registry, this.idPrefix, Self.class, Self::new);
        metrics.add(this.eventLoopGroup);
        this.addClosingTask(() -> metrics.remove(this.eventLoopGroup));
    }

    static final class Self {
        private final Set<EventLoopGroup> registry = ConcurrentHashMap.newKeySet(2);

        Self(MeterRegistry parent, MeterIdPrefix idPrefix) {
            String numWorkers = idPrefix.name("event.loop.workers");
            parent.gauge(numWorkers, idPrefix.tags(), (Object)this, Self::numWorkers);
            String pendingTasks = idPrefix.name("event.loop.pending.tasks");
            parent.gauge(pendingTasks, idPrefix.tags(), (Object)this, Self::pendingTasks);
        }

        void add(EventLoopGroup eventLoopGroup) {
            this.registry.add(eventLoopGroup);
        }

        void remove(EventLoopGroup eventLoopGroup) {
            this.registry.remove(eventLoopGroup);
        }

        double numWorkers() {
            int result = 0;
            for (EventLoopGroup group : this.registry) {
                if (group.isShutdown()) {
                    this.registry.remove(group);
                    continue;
                }
                result += Iterators.size(group.iterator());
            }
            return result;
        }

        double pendingTasks() {
            int result = 0;
            for (EventLoopGroup group : this.registry) {
                if (group.isShutdown()) {
                    this.remove(group);
                    continue;
                }
                for (EventExecutor eventLoop : group) {
                    if (!(eventLoop instanceof SingleThreadEventLoop)) continue;
                    result += ((SingleThreadEventLoop)eventLoop).pendingTasks();
                }
            }
            return result;
        }
    }
}

