/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.common.util.ResourceUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.DefaultGraphqlService;
import com.linecorp.armeria.server.graphql.ExecutionIdGenerator;
import com.linecorp.armeria.server.graphql.GraphqlConfigurator;
import com.linecorp.armeria.server.graphql.GraphqlErrorHandler;
import com.linecorp.armeria.server.graphql.GraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlWebSocketService;
import com.linecorp.armeria.server.graphql.RuntimeWiringConfigurator;
import com.linecorp.armeria.server.websocket.WebSocketServiceBuilder;
import graphql.GraphQL;
import graphql.com.google.common.base.Preconditions;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTransformer;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public final class GraphqlServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlServiceBuilder.class);
    private static final List<String> DEFAULT_SCHEMA_FILE_NAMES = ImmutableList.of((Object)"schema.graphqls", (Object)"schema.graphql");
    @Nullable
    private GraphQL graphql;
    @Nullable
    private ExecutionIdGenerator executionIdGenerator;
    @Nullable
    private ImmutableList.Builder<Instrumentation> instrumentations;
    @Nullable
    private ImmutableList.Builder<GraphqlConfigurator> graphqlBuilderConsumers;
    @Nullable
    private GraphQLSchema schema;
    @Nullable
    private ImmutableList.Builder<URL> schemaUrls;
    @Nullable
    private ImmutableList.Builder<RuntimeWiringConfigurator> runtimeWiringConfigurators;
    @Nullable
    private ImmutableList.Builder<GraphQLTypeVisitor> typeVisitors;
    @Nullable
    private ImmutableList.Builder<Consumer<? super DataLoaderRegistry>> dataLoaderRegistryConsumers;
    @Nullable
    private Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory;
    private boolean useBlockingTaskExecutor;
    @Nullable
    private GraphqlErrorHandler errorHandler;
    private boolean enableWebSocket;
    @Nullable
    private Consumer<WebSocketServiceBuilder> webSocketServiceCustomizer;

    GraphqlServiceBuilder() {
    }

    public GraphqlServiceBuilder graphql(GraphQL graphql) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.executionIdGenerator == null && this.instrumentations == null && this.graphqlBuilderConsumers == null && this.schema == null && this.schemaUrls == null && this.runtimeWiringConfigurators == null && this.typeVisitors == null ? 1 : 0) != 0, (Object)"graphql() and setting properties for a GraphQL are mutually exclusive.");
        this.graphql = Objects.requireNonNull(graphql, "graphql");
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder schemaFile(File ... schemaFiles) {
        return this.schemaFile((Iterable<? extends File>)ImmutableList.copyOf((Object[])Objects.requireNonNull(schemaFiles, "schemaFiles")));
    }

    @Deprecated
    public GraphqlServiceBuilder schemaFile(Iterable<? extends File> schemaFiles) {
        Objects.requireNonNull(schemaFiles, "schemaFiles");
        return this.schemaUrls0((Iterable)Streams.stream(schemaFiles).map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    @Deprecated
    public GraphqlServiceBuilder schemaUrls(String ... schemaUrls) {
        return this.schemaUrls((Iterable<String>)ImmutableList.copyOf((Object[])Objects.requireNonNull(schemaUrls, "schemaUrls")));
    }

    @Deprecated
    public GraphqlServiceBuilder schemaUrls(Iterable<String> schemaUrls) {
        Objects.requireNonNull(schemaUrls, "schemaUrls");
        return this.schemaUrls0((Iterable)Streams.stream(schemaUrls).map(url -> {
            try {
                return ResourceUtil.getUrl((String)url);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Not found schema file(s)", e);
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    private GraphqlServiceBuilder schemaUrls0(Iterable<URL> schemaUrls) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and schemaUrls() are mutually exclusive.");
        if (this.schemaUrls == null) {
            this.schemaUrls = ImmutableList.builder();
        }
        this.schemaUrls.addAll(Objects.requireNonNull(schemaUrls, "schemaUrls"));
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder schema(GraphQLSchema schema) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and schema() are mutually exclusive.");
        this.schema = Objects.requireNonNull(schema, "schema");
        return this;
    }

    public GraphqlServiceBuilder dataLoaderRegistry(Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.dataLoaderRegistryConsumers == null ? 1 : 0) != 0, (Object)"configureDataLoaderRegistry() and dataLoaderRegistry() are mutually exclusive.");
        this.dataLoaderRegistryFactory = Objects.requireNonNull(dataLoaderRegistryFactory, "dataLoaderRegistryFactory");
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder configureDataLoaderRegistry(Consumer<DataLoaderRegistry> ... configurers) {
        Objects.requireNonNull(configurers, "configurers");
        return this.configureDataLoaderRegistry((Iterable<? extends Consumer<? super DataLoaderRegistry>>)ImmutableList.copyOf((Object[])configurers));
    }

    @Deprecated
    public GraphqlServiceBuilder configureDataLoaderRegistry(Iterable<? extends Consumer<? super DataLoaderRegistry>> configurers) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.dataLoaderRegistryFactory == null ? 1 : 0) != 0, (Object)"configureDataLoaderRegistry() and dataLoaderRegistry() are mutually exclusive.");
        if (this.dataLoaderRegistryConsumers == null) {
            this.dataLoaderRegistryConsumers = ImmutableList.builder();
        }
        this.dataLoaderRegistryConsumers.addAll(Objects.requireNonNull(configurers, "configurers"));
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder runtimeWiring(RuntimeWiringConfigurator ... runtimeWiringConfigurators) {
        Objects.requireNonNull(runtimeWiringConfigurators, "runtimeWiringConfigurators");
        return this.runtimeWiring((Iterable<? extends RuntimeWiringConfigurator>)ImmutableList.copyOf((Object[])runtimeWiringConfigurators));
    }

    @Deprecated
    public GraphqlServiceBuilder runtimeWiring(Iterable<? extends RuntimeWiringConfigurator> configurators) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and runtimeWiring() are mutually exclusive.");
        if (this.runtimeWiringConfigurators == null) {
            this.runtimeWiringConfigurators = ImmutableList.builder();
        }
        this.runtimeWiringConfigurators.addAll(Objects.requireNonNull(configurators, "configurators"));
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder typeVisitors(GraphQLTypeVisitor ... typeVisitors) {
        return this.typeVisitors((Iterable<? extends GraphQLTypeVisitor>)ImmutableList.copyOf((Object[])Objects.requireNonNull(typeVisitors, "typeVisitors")));
    }

    @Deprecated
    public GraphqlServiceBuilder typeVisitors(Iterable<? extends GraphQLTypeVisitor> typeVisitors) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and typeVisitors() are mutually exclusive.");
        if (this.typeVisitors == null) {
            this.typeVisitors = ImmutableList.builder();
        }
        this.typeVisitors.addAll(Objects.requireNonNull(typeVisitors, "typeVisitors"));
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder instrumentation(Instrumentation ... instrumentations) {
        Objects.requireNonNull(instrumentations, "instrumentations");
        return this.instrumentation((Iterable<? extends Instrumentation>)ImmutableList.copyOf((Object[])instrumentations));
    }

    @Deprecated
    public GraphqlServiceBuilder instrumentation(Iterable<? extends Instrumentation> instrumentations) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and instrumentation() are mutually exclusive.");
        Objects.requireNonNull(instrumentations, "instrumentations");
        if (this.instrumentations == null) {
            this.instrumentations = ImmutableList.builder();
        }
        this.instrumentations.addAll(instrumentations);
        return this;
    }

    @Deprecated
    public GraphqlServiceBuilder configureGraphql(GraphqlConfigurator ... configurers) {
        return this.configureGraphql((Iterable<? extends GraphqlConfigurator>)ImmutableList.copyOf((Object[])Objects.requireNonNull(configurers, "configurers")));
    }

    @Deprecated
    public GraphqlServiceBuilder configureGraphql(Iterable<? extends GraphqlConfigurator> configurers) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and configureGraphql() are mutually exclusive.");
        Objects.requireNonNull(configurers, "configurers");
        if (this.graphqlBuilderConsumers == null) {
            this.graphqlBuilderConsumers = ImmutableList.builder();
        }
        this.graphqlBuilderConsumers.addAll(configurers);
        return this;
    }

    public GraphqlServiceBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public GraphqlServiceBuilder enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
        return this;
    }

    public GraphqlServiceBuilder webSocketServiceCustomizer(Consumer<WebSocketServiceBuilder> webSocketServiceCustomizer) {
        Objects.requireNonNull(webSocketServiceCustomizer, "webSocketServiceCustomizer");
        this.webSocketServiceCustomizer = webSocketServiceCustomizer;
        return this;
    }

    public GraphqlServiceBuilder errorHandler(GraphqlErrorHandler errorHandler) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        this.errorHandler = this.errorHandler == null ? errorHandler : this.errorHandler.orElse(errorHandler);
        return this;
    }

    public GraphqlServiceBuilder executionIdGenerator(ExecutionIdGenerator executionIdGenerator) {
        com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.graphql == null ? 1 : 0) != 0, (Object)"graphql() and executionIdGenerator() are mutually exclusive.");
        this.executionIdGenerator = Objects.requireNonNull(executionIdGenerator, "executionIdGenerator");
        return this;
    }

    public GraphqlService build() {
        Preconditions.checkArgument((this.enableWebSocket || this.webSocketServiceCustomizer == null ? 1 : 0) != 0, (Object)"enableWebSocket must be true to customize WebSocketServiceBuilder");
        GraphQL graphql = this.buildGraphql();
        Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory = this.buildDataLoaderRegistry();
        GraphqlErrorHandler errorHandler = this.errorHandler == null ? GraphqlErrorHandler.of() : this.errorHandler.orElse(GraphqlErrorHandler.of());
        DefaultGraphqlService graphqlService = new DefaultGraphqlService(graphql, dataLoaderRegistryFactory, this.useBlockingTaskExecutor, errorHandler);
        if (this.enableWebSocket) {
            return new GraphqlWebSocketService(graphqlService, dataLoaderRegistryFactory, this.webSocketServiceCustomizer);
        }
        return graphqlService;
    }

    private GraphQL buildGraphql() {
        if (this.graphql != null) {
            return this.graphql;
        }
        GraphQLSchema schema = this.buildSchema();
        ExecutionIdProvider executionProvider = ((ExecutionIdGenerator)MoreObjects.firstNonNull((Object)this.executionIdGenerator, (Object)ExecutionIdGenerator.of())).asExecutionProvider();
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema).executionIdProvider(executionProvider);
        if (this.instrumentations != null) {
            ImmutableList instrumentations = this.instrumentations.build();
            builder.instrumentation((Instrumentation)new ChainedInstrumentation((List)instrumentations));
        }
        if (this.graphqlBuilderConsumers != null) {
            ImmutableList graphqlBuilders = this.graphqlBuilderConsumers.build();
            for (GraphqlConfigurator configurer : graphqlBuilders) {
                configurer.configure(builder);
            }
        }
        return builder.build();
    }

    private GraphQLSchema buildSchema() {
        if (this.schema != null) {
            com.linecorp.armeria.internal.shaded.guava.base.Preconditions.checkState((this.schemaUrls == null && this.runtimeWiringConfigurators == null && this.typeVisitors == null ? 1 : 0) != 0, (Object)"Cannot add schemaUrl(or File), runtimeWiringConfigurator and typeVisitor when GraphqlSchema is specified.");
            return this.schema;
        }
        TypeDefinitionRegistry registry = this.typeDefinitionRegistry();
        RuntimeWiring runtimeWiring = this.buildRuntimeWiring();
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(registry, runtimeWiring);
        if (this.typeVisitors != null) {
            for (GraphQLTypeVisitor typeVisitor : this.typeVisitors.build()) {
                schema = SchemaTransformer.transformSchema((GraphQLSchema)schema, (GraphQLTypeVisitor)typeVisitor);
            }
        }
        return schema;
    }

    private TypeDefinitionRegistry typeDefinitionRegistry() {
        TypeDefinitionRegistry registry = new TypeDefinitionRegistry();
        SchemaParser parser = new SchemaParser();
        ImmutableList schemaUrlList = this.schemaUrls != null ? this.schemaUrls.build() : GraphqlServiceBuilder.defaultSchemaUrls();
        schemaUrlList.forEach(url -> {
            try (InputStream inputStream = url.openStream();){
                registry.merge(parser.parse(inputStream));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return registry;
    }

    private RuntimeWiring buildRuntimeWiring() {
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        if (this.runtimeWiringConfigurators != null) {
            this.runtimeWiringConfigurators.build().forEach(it -> it.configure(runtimeWiringBuilder));
        }
        return runtimeWiringBuilder.build();
    }

    private static List<URL> defaultSchemaUrls() {
        ClassLoader classLoader = GraphqlServiceBuilder.class.getClassLoader();
        List schemaFiles = (List)DEFAULT_SCHEMA_FILE_NAMES.stream().map(classLoader::getResource).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (schemaFiles.isEmpty()) {
            throw new IllegalStateException("Not found schema file(s)");
        }
        logger.info("Found schema files: {}", (Object)schemaFiles);
        return schemaFiles;
    }

    private Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> buildDataLoaderRegistry() {
        Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFactory;
        if (this.dataLoaderRegistryFactory != null) {
            dataLoaderRegistryFactory = this.dataLoaderRegistryFactory;
        } else if (this.dataLoaderRegistryConsumers != null) {
            DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
            for (Consumer configurer : this.dataLoaderRegistryConsumers.build()) {
                configurer.accept(dataLoaderRegistry);
            }
            dataLoaderRegistryFactory = ctx -> dataLoaderRegistry;
        } else {
            dataLoaderRegistryFactory = ctx -> new DataLoaderRegistry();
        }
        return dataLoaderRegistryFactory;
    }
}

