/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class NamingUtils {
    private static final Pattern CLUSTER_NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z-]+$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");

    public static String getGroupedName(String serviceName, String groupName) {
        if (StringUtils.isBlank(serviceName)) {
            throw new IllegalArgumentException("Param 'serviceName' is illegal, serviceName is blank");
        }
        if (StringUtils.isBlank(groupName)) {
            throw new IllegalArgumentException("Param 'groupName' is illegal, groupName is blank");
        }
        String resultGroupedName = groupName + "@@" + serviceName;
        return resultGroupedName.intern();
    }

    public static String getServiceName(String serviceNameWithGroup) {
        if (StringUtils.isBlank(serviceNameWithGroup)) {
            return "";
        }
        if (!serviceNameWithGroup.contains("@@")) {
            return serviceNameWithGroup;
        }
        return serviceNameWithGroup.split("@@")[1];
    }

    public static String getGroupName(String serviceNameWithGroup) {
        if (StringUtils.isBlank(serviceNameWithGroup)) {
            return "";
        }
        if (!serviceNameWithGroup.contains("@@")) {
            return "DEFAULT_GROUP";
        }
        return serviceNameWithGroup.split("@@")[0];
    }

    public static boolean isServiceNameCompatibilityMode(String serviceName) {
        return !StringUtils.isBlank(serviceName) && serviceName.contains("@@");
    }

    public static void checkServiceNameFormat(String combineServiceName) {
        String[] split = combineServiceName.split("@@");
        if (split.length <= 1) {
            throw new IllegalArgumentException("Param 'serviceName' is illegal, it should be format as 'groupName@@serviceName'");
        }
        if (split[0].isEmpty()) {
            throw new IllegalArgumentException("Param 'serviceName' is illegal, groupName can't be empty");
        }
    }

    public static String getGroupedNameOptional(String serviceName, String groupName) {
        return groupName + "@@" + serviceName;
    }

    public static void checkInstanceIsLegal(Instance instance) throws NacosException {
        if (null == instance) {
            throw new NacosApiException(400, ErrorCode.INSTANCE_ERROR, "Instance can not be null.");
        }
        if (instance.getInstanceHeartBeatTimeOut() < instance.getInstanceHeartBeatInterval() || instance.getIpDeleteTimeout() < instance.getInstanceHeartBeatInterval()) {
            throw new NacosApiException(400, ErrorCode.INSTANCE_ERROR, "Instance 'heart beat interval' must less than 'heart beat timeout' and 'ip delete timeout'.");
        }
        if (!StringUtils.isEmpty(instance.getClusterName()) && !CLUSTER_NAME_PATTERN.matcher(instance.getClusterName()).matches()) {
            throw new NacosApiException(400, ErrorCode.INSTANCE_ERROR, String.format("Instance 'clusterName' should be characters with only 0-9a-zA-Z-. (current: %s)", instance.getClusterName()));
        }
    }

    public static void checkInstanceIsEphemeral(Instance instance) throws NacosException {
        if (!instance.isEphemeral()) {
            throw new NacosApiException(400, ErrorCode.INSTANCE_ERROR, String.format("Batch registration does not allow persistent instance registration , Instance\uff1a%s", instance));
        }
    }

    public static void batchCheckInstanceIsLegal(List<Instance> instances) throws NacosException {
        HashSet<Instance> newInstanceSet = new HashSet<Instance>(instances);
        for (Instance instance : newInstanceSet) {
            NamingUtils.checkInstanceIsEphemeral(instance);
            NamingUtils.checkInstanceIsLegal(instance);
        }
    }

    public static boolean isNumber(String str) {
        return !StringUtils.isEmpty(str) && NUMBER_PATTERN.matcher(str).matches();
    }
}

