/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.DefaultTraverserContext;
import graphql.util.NodeLocation;
import graphql.util.TraverserContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@Internal
public abstract class TraverserState<T> {
    private Object sharedContextData;
    private final Deque<Object> state;
    private final Set<T> visited = new LinkedHashSet<T>();

    private TraverserState(Object sharedContextData) {
        this.sharedContextData = sharedContextData;
        this.state = new ArrayDeque<Object>(32);
    }

    public static <U> TraverserState<U> newQueueState(Object sharedContextData) {
        return new QueueTraverserState(sharedContextData);
    }

    public static <U> TraverserState<U> newStackState(Object sharedContextData) {
        return new StackTraverserState(sharedContextData);
    }

    public abstract void pushAll(TraverserContext<T> var1, Function<? super T, Map<String, ? extends List<T>>> var2);

    public Object pop() {
        return this.state.pop();
    }

    public void addNewContexts(Collection<? extends T> children, TraverserContext<T> parentContext) {
        Assert.assertNotNull(children).stream().map(child -> this.newContext(child, parentContext, null)).forEach(this.state::add);
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public void addVisited(T visited) {
        this.visited.add(visited);
    }

    public DefaultTraverserContext<T> newRootContext(Map<Class<?>, Object> vars) {
        return this.newContextImpl(null, null, vars, null, true);
    }

    private DefaultTraverserContext<T> newContext(T o, TraverserContext<T> parent, NodeLocation position) {
        return this.newContextImpl(o, parent, new LinkedHashMap(), position, false);
    }

    private DefaultTraverserContext<T> newContextImpl(T curNode, TraverserContext<T> parent, Map<Class<?>, Object> vars, NodeLocation nodeLocation, boolean isRootContext) {
        Assert.assertNotNull(vars);
        return new DefaultTraverserContext<T>(curNode, parent, this.visited, vars, this.sharedContextData, nodeLocation, isRootContext, false);
    }

    public static class EndList<U> {
        public Map<String, List<TraverserContext<U>>> childrenContextMap;
    }

    private static class QueueTraverserState<U>
    extends TraverserState<U> {
        private QueueTraverserState(Object sharedContextData) {
            super(sharedContextData);
        }

        @Override
        public void pushAll(TraverserContext<U> traverserContext, Function<? super U, Map<String, ? extends List<U>>> getChildren) {
            LinkedHashMap childrenContextMap = new LinkedHashMap();
            if (!traverserContext.isDeleted()) {
                Map<String, List<U>> childrenMap = getChildren.apply(traverserContext.thisNode());
                childrenMap.keySet().forEach(key -> {
                    List children = (List)childrenMap.get(key);
                    for (int i = 0; i < children.size(); ++i) {
                        Object child = Assert.assertNotNull(children.get(i), () -> "null child for key " + key);
                        NodeLocation nodeLocation = new NodeLocation((String)key, i);
                        DefaultTraverserContext context = super.newContext(child, traverserContext, nodeLocation);
                        childrenContextMap.computeIfAbsent((String)key, notUsed -> new ArrayList());
                        ((List)childrenContextMap.get(key)).add(context);
                        this.state.add(context);
                    }
                });
            }
            EndList endList = new EndList();
            endList.childrenContextMap = childrenContextMap;
            this.state.add(endList);
            this.state.add(traverserContext);
        }
    }

    private static class StackTraverserState<U>
    extends TraverserState<U> {
        private StackTraverserState(Object sharedContextData) {
            super(sharedContextData);
        }

        @Override
        public void pushAll(TraverserContext<U> traverserContext, Function<? super U, Map<String, ? extends List<U>>> getChildren) {
            this.state.push(traverserContext);
            EndList endList = new EndList();
            this.state.push(endList);
            LinkedHashMap childrenContextMap = new LinkedHashMap();
            if (!traverserContext.isDeleted()) {
                Map<String, List<U>> childrenMap = getChildren.apply(traverserContext.thisNode());
                childrenMap.keySet().forEach(key -> {
                    List children = (List)childrenMap.get(key);
                    for (int i = children.size() - 1; i >= 0; --i) {
                        Object child = Assert.assertNotNull(children.get(i), () -> "null child for key " + key);
                        NodeLocation nodeLocation = new NodeLocation((String)key, i);
                        DefaultTraverserContext context = super.newContext(child, traverserContext, nodeLocation);
                        this.state.push(context);
                        childrenContextMap.computeIfAbsent((String)key, notUsed -> new ArrayList());
                        ((List)childrenContextMap.get(key)).add(0, context);
                    }
                });
            }
            endList.childrenContextMap = childrenContextMap;
        }
    }
}

