/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.webconsole.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Map;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.apache.sling.commons.log.logback.webconsole.LogPanel;
import org.apache.sling.commons.log.logback.webconsole.LoggerConfig;
import org.apache.sling.commons.log.logback.webconsole.TailerOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class LogWebConsolePlugin
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final String RES_LOC = "slinglog/res/ui";
    private static final String[] CSS_REFS = new String[]{"slinglog/res/ui/jquery.autocomplete.css", "slinglog/res/ui/prettify.css", "slinglog/res/ui/log.css"};
    private final transient LogPanel panel;

    public LogWebConsolePlugin(LogPanel panel) {
        this.panel = panel;
    }

    public ServiceRegistration<Servlet> register(BundleContext context) {
        Dictionary props = FrameworkUtil.asDictionary(Map.of("felix.webconsole.label", "slinglog", "felix.webconsole.title", "Log Support", "felix.webconsole.category", "Sling", "felix.webconsole.css", CSS_REFS));
        return context.registerService(Servlet.class, (Object)this, props);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("GET".equalsIgnoreCase(req.getMethod()) && req.getPathInfo() != null && req.getPathInfo().endsWith("tailer.txt")) {
            this.renderContent(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    public void renderContent(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw = resp.getWriter();
        String consoleAppRoot = LogWebConsolePlugin.getAppRoot(req);
        if (req.getPathInfo() != null && req.getPathInfo().endsWith("tailer.txt")) {
            resp.setContentType("text/plain");
            String appenderName = req.getParameter("name");
            String regex = req.getParameter("grep");
            LogWebConsolePlugin.addNoSniffHeader(resp);
            if (appenderName == null) {
                pw.printf("Provide appender name via [%s] request parameter%n", "name");
                return;
            }
            int numOfLines = 0;
            try {
                numOfLines = Integer.valueOf(req.getParameter("tail"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            TailerOptions opts = new TailerOptions(numOfLines, regex);
            this.panel.tail(pw, appenderName, opts);
            return;
        }
        this.panel.render(pw, consoleAppRoot);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean isDelete = req.getParameter("delete") != null;
        String pid = req.getParameter("pid");
        if (isDelete) {
            this.panel.deleteLoggerConfig(pid);
        } else {
            String logger = req.getParameter("logger");
            String logLevel = req.getParameter("loglevel");
            String logFile = req.getParameter("logfile");
            boolean additive = Boolean.parseBoolean(req.getParameter("logAdditive"));
            String[] loggers = req.getParameterValues("logger");
            if (null != logger) {
                LoggerConfig config = new LoggerConfig(pid, logLevel, loggers, logFile, additive);
                this.panel.createLoggerConfig(config);
            }
        }
        String consoleAppRoot = LogWebConsolePlugin.getAppRoot(req);
        resp.sendRedirect(consoleAppRoot + "/slinglog");
    }

    private static String getAppRoot(HttpServletRequest req) {
        return (String)req.getAttribute("felix.webconsole.appRoot");
    }

    private static void addNoSniffHeader(HttpServletResponse resp) {
        resp.setHeader("X-Content-Type-Options", "nosniff");
    }
}

