/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.RankedService;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.RankedServiceFive;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.RankedServiceTen;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service6VolatileMultipleReferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MockServiceReferencesSortTest {
    private BundleContext bundleContext;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testAllWithRanking() {
        this.registerStringServiceWithRanking("A", 3);
        this.registerStringServiceWithRanking("B", 5);
        this.registerStringServiceWithRanking("C", 4);
        this.registerStringServiceWithRanking("D", 1);
        this.registerStringServiceWithRanking("E", 2);
        Assert.assertEquals((Object)"DEACB", (Object)this.getSortedServicesString());
        Assert.assertEquals((Object)"B", (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(String.class)));
    }

    @Test
    public void testAllWithoutRanking() {
        this.registerStringServiceWithoutRanking("A");
        this.registerStringServiceWithoutRanking("B");
        this.registerStringServiceWithoutRanking("C");
        this.registerStringServiceWithoutRanking("D");
        this.registerStringServiceWithoutRanking("E");
        Assert.assertEquals((Object)"EDCBA", (Object)this.getSortedServicesString());
        Assert.assertEquals((Object)"A", (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(String.class)));
    }

    @Test
    public void testMixed() {
        this.registerStringServiceWithoutRanking("A");
        this.registerStringServiceWithRanking("B", 5);
        this.registerStringServiceWithoutRanking("C");
        this.registerStringServiceWithRanking("D", 10);
        this.registerStringServiceWithoutRanking("E");
        Assert.assertEquals((Object)"ECABD", (Object)this.getSortedServicesString());
        Assert.assertEquals((Object)"D", (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(String.class)));
    }

    @Test
    public void testVolatileCollectionReference() {
        RankedServiceTen rankedServiceTen = new RankedServiceTen();
        this.bundleContext.registerService(RankedService.class.getName(), (Object)rankedServiceTen, null);
        MockOsgi.activate((Object)rankedServiceTen, (BundleContext)this.bundleContext);
        RankedServiceFive rankedServiceFive = new RankedServiceFive();
        this.bundleContext.registerService(RankedService.class.getName(), (Object)rankedServiceFive, null);
        MockOsgi.activate((Object)rankedServiceFive, (BundleContext)this.bundleContext);
        Service6VolatileMultipleReferences service6VolatileMultipleReferences = new Service6VolatileMultipleReferences();
        this.bundleContext.registerService(Service6VolatileMultipleReferences.class.getName(), (Object)service6VolatileMultipleReferences, null);
        MockOsgi.injectServices((Object)service6VolatileMultipleReferences, (BundleContext)this.bundleContext);
        Assert.assertEquals((String)"Should get highest when getting one service", (Object)rankedServiceTen, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(RankedService.class)));
        Assert.assertEquals((String)"Should have order from lowest to highest on sorted ranked services", (Object)"RankedServiceFive=5RankedServiceTen=10", (Object)this.getSortedRankedServices());
        Assert.assertEquals((String)"Should have order from lowest to highest on volatile reference list", (Object)"RankedServiceFive=5RankedServiceTen=10", (Object)service6VolatileMultipleReferences.getRanks());
    }

    @Test
    public void testConsistentRankedServicesSorting() {
        RankedService serviceRanking0 = (RankedService)Mockito.mock(RankedService.class);
        this.bundleContext.registerService(RankedService.class, (Object)serviceRanking0, this.createServiceRankingDictionary(0));
        RankedService serviceRankingMin5 = (RankedService)Mockito.mock(RankedService.class);
        this.bundleContext.registerService(RankedService.class, (Object)serviceRankingMin5, this.createServiceRankingDictionary(-5));
        RankedService serviceRanking5 = (RankedService)Mockito.mock(RankedService.class);
        this.bundleContext.registerService(RankedService.class, (Object)serviceRanking5, this.createServiceRankingDictionary(5));
        Service6VolatileMultipleReferences service = (Service6VolatileMultipleReferences)MockOsgi.registerInjectActivateService(Service6VolatileMultipleReferences.class, (BundleContext)this.bundleContext);
        List referencedServices = service.getRankedServices();
        Assert.assertNotNull((Object)referencedServices);
        Assert.assertEquals((long)3L, (long)referencedServices.size());
        Assert.assertEquals((Object)serviceRankingMin5, referencedServices.get(0));
        Assert.assertEquals((Object)serviceRanking0, referencedServices.get(1));
        Assert.assertEquals((Object)serviceRanking5, referencedServices.get(2));
        RankedService serviceRankingMin999 = (RankedService)Mockito.mock(RankedService.class);
        this.bundleContext.registerService(RankedService.class, (Object)serviceRankingMin999, this.createServiceRankingDictionary(-999));
        RankedService serviceRanking1 = (RankedService)Mockito.mock(RankedService.class);
        this.bundleContext.registerService(RankedService.class, (Object)serviceRanking1, this.createServiceRankingDictionary(1));
        Assert.assertEquals((long)5L, (long)referencedServices.size());
        Assert.assertEquals((Object)serviceRankingMin999, referencedServices.get(0));
        Assert.assertEquals((Object)serviceRankingMin5, referencedServices.get(1));
        Assert.assertEquals((Object)serviceRanking0, referencedServices.get(2));
        Assert.assertEquals((Object)serviceRanking1, referencedServices.get(3));
        Assert.assertEquals((Object)serviceRanking5, referencedServices.get(4));
    }

    private Dictionary<String, Object> createServiceRankingDictionary(int serviceRanking) {
        return new Hashtable<String, Object>(Map.of("service.ranking", serviceRanking));
    }

    private String getSortedRankedServices() {
        Object[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(RankedService.class.getName(), null);
        }
        catch (InvalidSyntaxException ise) {
            Assert.fail((String)"Unexpected InvalidSyntaxException");
        }
        Assert.assertNotNull((String)"Expecting our service references", (Object)refs);
        Arrays.sort(refs);
        StringBuilder sb = new StringBuilder();
        for (Object ref : refs) {
            RankedService rankedService = (RankedService)this.bundleContext.getService((ServiceReference)ref);
            sb.append(rankedService.getClass().getSimpleName()).append("=").append(rankedService.getRanking());
            this.bundleContext.ungetService((ServiceReference)ref);
        }
        return sb.toString();
    }

    private ServiceRegistration<?> registerStringServiceWithoutRanking(String serviceValue) {
        return this.bundleContext.registerService(String.class, (Object)serviceValue, new Hashtable());
    }

    private ServiceRegistration<?> registerStringServiceWithRanking(String serviceValue, int index) {
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", index);
        return this.bundleContext.registerService(String.class, (Object)serviceValue, props);
    }

    private String getSortedServicesString() {
        Object[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(String.class.getName(), null);
        }
        catch (InvalidSyntaxException ise) {
            Assert.fail((String)"Unexpected InvalidSyntaxException");
        }
        Assert.assertNotNull((String)"Expecting our service references", (Object)refs);
        Arrays.sort(refs);
        StringBuilder sb = new StringBuilder();
        for (Object ref : refs) {
            sb.append(this.bundleContext.getService((ServiceReference)ref).toString());
            this.bundleContext.ungetService((ServiceReference)ref);
        }
        return sb.toString();
    }
}

