/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.internal.concurrent;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.jackrabbit.guava.common.util.concurrent.ListenableFuture;
import org.jetbrains.annotations.NotNull;

public class FutureConverter {
    private static final Executor DIRECT_EXECUTOR = Runnable::run;

    private FutureConverter() {
    }

    public static <T> List<CompletableFuture<T>> toCompletableFuture(List<? extends ListenableFuture<T>> listenableFutures) {
        return listenableFutures.stream().map(FutureConverter::toCompletableFuture).collect(Collectors.toList());
    }

    public static <T> CompletableFuture<T> toCompletableFuture(final ListenableFuture<T> listenableFuture) {
        CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean canceled = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return canceled;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    return super.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    return super.get(timeout, unit);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        };
        if (listenableFuture.isDone()) {
            FutureConverter.handleConversion(listenableFuture, completable);
        } else {
            listenableFuture.addListener(() -> FutureConverter.handleConversion(listenableFuture, completable), DIRECT_EXECUTOR);
        }
        return completable;
    }

    public static <T> ListenableFuture<T> toListenableFuture(final CompletableFuture<T> completableFuture) {
        return new ListenableFuture<T>(){

            @Override
            public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
                completableFuture.whenComplete((result, ex) -> listener.run());
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return completableFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return completableFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return completableFuture.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    return completableFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }

            @Override
            public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    return completableFuture.get(timeout, unit);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        };
    }

    private static <T> void handleConversion(ListenableFuture<T> listenableFuture, CompletableFuture<T> completable) {
        try {
            if (listenableFuture.isCancelled()) {
                completable.cancel(false);
            } else {
                completable.complete(listenableFuture.get());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            completable.completeExceptionally(ex);
        }
        catch (Exception ex) {
            completable.completeExceptionally(ex.getCause() != null ? ex.getCause() : ex);
        }
    }
}

