/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike$NullOrder$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SortArray$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array[, ascendingOrder]) - Sorts the input array in ascending or descending order\n      according to the natural ordering of the array elements. NaN is greater than any non-NaN\n      elements for double/float type. Null elements will be placed at the beginning of the returned\n      array in ascending order or at the end of the returned array in descending order.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'), true);\n       [null,\"a\",\"b\",\"c\",\"d\"]\n  ", group="array_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001\u0002\u0012$\u0001BB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u00151\u0006\u0001\"\u0001\\\u0011\u0015q\u0006\u0001\"\u0011P\u0011\u0015y\u0006\u0001\"\u0011P\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015A\b\u0001\"\u0011P\u0011\u0015I\b\u0001\"\u0011{\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011\u0011\u000f\u0001\u0005R\u0005M\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t)\tAI\u0001\n\u0003\t9\tC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0001\u0002\b\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0015\u0005\n\u0003c\u0003\u0011\u0011!C\u0001\u0003gC\u0011\"a/\u0001\u0003\u0003%\t!!0\t\u0013\u0005\r\u0007!!A\u0005B\u0005\u0015\u0007\"CAj\u0001\u0005\u0005I\u0011AAk\u0011%\ty\u000eAA\u0001\n\u0003\n\toB\u0005\u0003\u0006\r\n\t\u0011#\u0001\u0003\b\u0019A!eIA\u0001\u0012\u0003\u0011I\u0001\u0003\u0004W9\u0011\u0005!q\u0003\u0005\n\u00053a\u0012\u0011!C#\u00057A\u0011B!\b\u001d\u0003\u0003%\tIa\b\t\u0013\t\u0015B$!A\u0005\u0002\n\u001d\u0002\"\u0003B\u001d9\u0005\u0005I\u0011\u0002B\u001e\u0005%\u0019vN\u001d;BeJ\f\u0017P\u0003\u0002%K\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011'\u000e\u001d@\u000b.\u0003\"AM\u001a\u000e\u0003\rJ!\u0001N\u0012\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001a7\u0013\t94EA\u0007BeJ\f\u0017pU8si2K7.\u001a\t\u0003sqr!A\r\u001e\n\u0005m\u001a\u0013a\u00029bG.\fw-Z\u0005\u0003{y\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002<GA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iJ\u0001\u0007KJ\u0014xN]:\n\u0005\u0011\u000b%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\u000fA\u0013x\u000eZ;diB\u0011a\tT\u0005\u0003\u001b\u001e\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAAY1tKV\t\u0001\u000b\u0005\u00023#&\u0011!k\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00022bg\u0016\u0004\u0013AD1tG\u0016tG-\u001b8h\u001fJ$WM]\u0001\u0010CN\u001cWM\u001c3j]\u001e|%\u000fZ3sA\u00051A(\u001b8jiz\"2\u0001W-[!\t\u0011\u0004\u0001C\u0003O\u000b\u0001\u0007\u0001\u000bC\u0003U\u000b\u0001\u0007\u0001\u000b\u0006\u0002Y9\")QL\u0002a\u0001!\u0006\tQ-\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!Z\u0014\u0002\u000bQL\b/Z:\n\u0005\u001d$'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001k!\rY'/\u001e\b\u0003YFt!!\u001c9\u000e\u00039T!a\\\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015BA\u001eH\u0013\t\u0019HOA\u0002TKFT!aO$\u0011\u0005\r4\u0018BA<e\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\bbeJ\f\u00170\u0012=qe\u0016\u001c8/[8o\u0003%qW\u000f\u001c7Pe\u0012,'/F\u0001|!\ra\u0018q\u0003\b\u0004{\u0006Mab\u0001@\u0002\u00129\u0019q0a\u0004\u000f\t\u0005\u0005\u0011Q\u0002\b\u0005\u0003\u0007\tYA\u0004\u0003\u0002\u0006\u0005%abA7\u0002\b%\ta&\u0003\u0002-[%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005\u0011*\u0013bAA\u000bG\u0005i\u0011I\u001d:bsN{'\u000f\u001e'jW\u0016LA!!\u0007\u0002\u001c\tIa*\u001e7m\u001fJ$WM\u001d\u0006\u0004\u0003+\u0019\u0013aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014K\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002,\u0005\u0015\"a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005E\u0012qGA\u001e!\r1\u00151G\u0005\u0004\u0003k9%aA!os\"9\u0011\u0011\b\bA\u0002\u0005E\u0012!B1se\u0006L\bbBA\u001f\u001d\u0001\u0007\u0011\u0011G\u0001\nCN\u001cWM\u001c3j]\u001e\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\r\u0013qJA-!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%G\u000591m\u001c3fO\u0016t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003#z\u0001\u0019AA*\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u000b\n)&\u0003\u0003\u0002X\u0005\u001d#AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u00037z\u0001\u0019AA\"\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0019\u0011\t\u0005\r\u00141\u000e\b\u0005\u0003K\n9\u0007\u0005\u0002n\u000f&\u0019\u0011\u0011N$\u0002\rA\u0013X\rZ3g\u0013\u0011\ti'a\u001c\u0003\rM#(/\u001b8h\u0015\r\tIgR\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001WA;\u0003sBa!a\u001e\u0012\u0001\u0004\u0001\u0016a\u00028fo2+g\r\u001e\u0005\u0007\u0003w\n\u0002\u0019\u0001)\u0002\u00119,wOU5hQR\fAaY8qsR)\u0001,!!\u0002\u0004\"9aJ\u0005I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0013!\u0003\u0005\r\u0001U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIIK\u0002Q\u0003\u0017[#!!$\u0011\t\u0005=\u0015\u0011T\u0007\u0003\u0003#SA!a%\u0002\u0016\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/;\u0015AC1o]>$\u0018\r^5p]&!\u00111TAI\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0016\u0001\u00026bm\u0006LA!!\u001c\u0002(\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0017\t\u0004\r\u0006]\u0016bAA]\u000f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011GA`\u0011%\t\tmFA\u0001\u0002\u0004\t),A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0004b!!3\u0002P\u0006ERBAAf\u0015\r\timR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAi\u0003\u0017\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q[Ao!\r1\u0015\u0011\\\u0005\u0004\u00037<%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0003L\u0012\u0011!a\u0001\u0003c\ta!Z9vC2\u001cH\u0003BAl\u0003GD\u0011\"!1\u001b\u0003\u0003\u0005\r!!\r)'\u0001\t9/!<\u0002p\u0006M\u0018Q_A}\u0003w\fyP!\u0001\u0011\u0007I\nI/C\u0002\u0002l\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002r\u0006\u00119P\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1z72\u0002\u0013m]2f]\u0012LgnZ(sI\u0016\u0014X,\u000b\u0011.AM{'\u000f^:!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002Jg\u000eI1tG\u0016tG-\u001b8hA=\u0014\b\u0005Z3tG\u0016tG-\u001b8hA=\u0014H-\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011bG\u000e|'\u000fZ5oO\u0002\"x\u000e\t;iK\u0002r\u0017\r^;sC2\u0004sN\u001d3fe&tw\rI8gAQDW\rI1se\u0006L\b%\u001a7f[\u0016tGo\u001d\u0018!\u001d\u0006t\u0005%[:!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011b]f\u0004cn\u001c8.\u001d\u0006t%\u0002\t\u0011!A\u0001\u0002S\r\\3nK:$8\u000f\t4pe\u0002\"w.\u001e2mK>2Gn\\1uAQL\b/\u001a\u0018!\u001dVdG\u000eI3mK6,g\u000e^:!o&dG\u000e\t2fAAd\u0017mY3eA\u0005$\b\u0005\u001e5fA\t,w-\u001b8oS:<\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0006!A\u0001\u0002\u0003\u0005I1se\u0006L\b%\u001b8!CN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe\u0002z'\u000fI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\u0012X\r^;s]\u0016$\u0007%\u0019:sCf\u0004\u0013N\u001c\u0011eKN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q_\u0001n\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001d\u0012w\u0005\f\u0011(I\u001eb\u0003E\\;mY2\u0002seY\u0014-A\u001d\nw%\u000b\u0017!iJ,X-K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7:,H\u000e\u001c\u0017#C\nb#E\u0019\u0012-E\r\u0014CF\t3#;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002~\u0006Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011\u0019!A\u00032]Ur\u0003'A\u0005T_J$\u0018I\u001d:bsB\u0011!\u0007H\n\u00059\t-1\nE\u0004\u0003\u000e\tM\u0001\u000b\u0015-\u000e\u0005\t=!b\u0001B\t\u000f\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u000b\u0005\u001f\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u00119!\u0001\u0005u_N#(/\u001b8h)\t\t\u0019+A\u0003baBd\u0017\u0010F\u0003Y\u0005C\u0011\u0019\u0003C\u0003O?\u0001\u0007\u0001\u000bC\u0003U?\u0001\u0007\u0001+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t%\"Q\u0007\t\u0006\r\n-\"qF\u0005\u0004\u0005[9%AB(qi&|g\u000eE\u0003G\u0005c\u0001\u0006+C\u0002\u00034\u001d\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u001cA\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u001f!\u0011\t)Ka\u0010\n\t\t\u0005\u0013q\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class SortArray
extends BinaryExpression
implements ArraySortLike,
package.NullIntolerant,
QueryErrorsBase,
scala.Serializable {
    private final Expression base;
    private final Expression ascendingOrder;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SortArray sortArray) {
        return SortArray$.MODULE$.unapply(sortArray);
    }

    public static Function1<Tuple2<Expression, Expression>, SortArray> tupled() {
        return SortArray$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, SortArray>> curried() {
        return SortArray$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public Object sortEval(Object array, boolean ascending) {
        return ArraySortLike.sortEval$(this, array, ascending);
    }

    @Override
    public String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        return ArraySortLike.sortCodegen$(this, ctx, ev, base, order);
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    private DataType elementType$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ArraySortLike.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    public Expression base() {
        return this.base;
    }

    public Expression ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public Expression left() {
        return this.base();
    }

    @Override
    public Expression right() {
        return this.ascendingOrder();
    }

    @Override
    public DataType dataType() {
        return this.base().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Expression arrayExpression() {
        return this.base();
    }

    @Override
    public int nullOrder() {
        return ArraySortLike$NullOrder$.MODULE$.Least();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = this.base().dataType();
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType dt = arrayType.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                Expression expression = this.ascendingOrder();
                if (expression instanceof Literal) {
                    Literal literal = (Literal)expression;
                    DataType dataType2 = literal.dataType();
                    if (literal.value() instanceof Boolean && BooleanType$.MODULE$.equals(dataType2)) {
                        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    }
                }
                return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.ascendingOrder())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.ascendingOrder().dataType()))}))));
            }
        }
        if (bl) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_ORDERING_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)this.base().dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.base())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.base().dataType()))}))));
    }

    @Override
    public Object nullSafeEval(Object array, Object ascending) {
        return this.sortEval(array, BoxesRunTime.unboxToBoolean((Object)ascending));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(b, order) -> this.sortCodegen(ctx, ev, (String)b, (String)order));
    }

    @Override
    public String prettyName() {
        return "sort_array";
    }

    @Override
    public SortArray withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public SortArray copy(Expression base, Expression ascendingOrder) {
        return new SortArray(base, ascendingOrder);
    }

    public Expression copy$default$1() {
        return this.base();
    }

    public Expression copy$default$2() {
        return this.ascendingOrder();
    }

    @Override
    public String productPrefix() {
        return "SortArray";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.base();
            }
            case 1: {
                return this.ascendingOrder();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SortArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SortArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        SortArray sortArray = (SortArray)x$1;
        Expression expression = this.base();
        Expression expression2 = sortArray.base();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.ascendingOrder();
        Expression expression4 = sortArray.ascendingOrder();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sortArray.canEqual(this)) return false;
        return true;
    }

    public SortArray(Expression base, Expression ascendingOrder) {
        this.base = base;
        this.ascendingOrder = ascendingOrder;
        ExpectsInputTypes.$init$(this);
        ArraySortLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public SortArray(Expression e) {
        this(e, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)true)));
    }
}

