/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import scala.tools.asm.Attribute;
import scala.tools.asm.ConstantDynamic;
import scala.tools.asm.Handle;
import scala.tools.asm.Label;
import scala.tools.asm.Type;
import scala.tools.asm.TypePath;
import scala.tools.asm.util.ASMifiable;
import scala.tools.asm.util.Printer;

public class ASMifier
extends Printer {
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;
    private static final int ACCESS_MODULE = 0x200000;
    private static final String ANNOTATION_VISITOR = "annotationVisitor";
    private static final String ANNOTATION_VISITOR0 = "annotationVisitor0 = ";
    private static final String NEW_OBJECT_ARRAY = ", new Object[] {";
    private static final String END_ARRAY = " });\n";
    private static final String END_PARAMETERS = ");\n\n";
    private static final String VISIT_END = ".visitEnd();\n";
    private static final Map<Integer, String> CLASS_VERSIONS;
    protected final String name;
    protected final int id;
    protected Map<Label, String> labelNames;

    public ASMifier() {
        this(393216, "classWriter", 0);
        if (this.getClass() != ASMifier.class) {
            throw new IllegalStateException();
        }
    }

    protected ASMifier(int api, String visitorVariableName, int annotationVisitorId) {
        super(api);
        this.name = visitorVariableName;
        this.id = annotationVisitorId;
    }

    public static void main(String[] args) throws IOException {
        String usage = "Prints the ASM code to generate the given class.\nUsage: ASMifier [-debug] <fully qualified class name or class file name>";
        ASMifier.main(usage, new ASMifier(), args);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String simpleName;
        if (name == null) {
            simpleName = "module-info";
        } else {
            int lastSlashIndex = name.lastIndexOf(47);
            if (lastSlashIndex == -1) {
                simpleName = name;
            } else {
                this.text.add("package asm." + name.substring(0, lastSlashIndex).replace('/', '.') + ";\n");
                simpleName = name.substring(lastSlashIndex + 1).replace('-', '_');
            }
        }
        this.text.add("import scala.tools.asm.AnnotationVisitor;\n");
        this.text.add("import scala.tools.asm.Attribute;\n");
        this.text.add("import scala.tools.asm.ClassReader;\n");
        this.text.add("import scala.tools.asm.ClassWriter;\n");
        this.text.add("import scala.tools.asm.ConstantDynamic;\n");
        this.text.add("import scala.tools.asm.FieldVisitor;\n");
        this.text.add("import scala.tools.asm.Handle;\n");
        this.text.add("import scala.tools.asm.Label;\n");
        this.text.add("import scala.tools.asm.MethodVisitor;\n");
        this.text.add("import scala.tools.asm.Opcodes;\n");
        this.text.add("import scala.tools.asm.Type;\n");
        this.text.add("import scala.tools.asm.TypePath;\n");
        this.text.add("public class " + simpleName + "Dump implements Opcodes {\n\n");
        this.text.add("public static byte[] dump () throws Exception {\n\n");
        this.text.add("ClassWriter classWriter = new ClassWriter(0);\n");
        this.text.add("FieldVisitor fieldVisitor;\n");
        this.text.add("MethodVisitor methodVisitor;\n");
        this.text.add("AnnotationVisitor annotationVisitor0;\n\n");
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visit(");
        String versionString = CLASS_VERSIONS.get(version);
        if (versionString != null) {
            this.stringBuilder.append(versionString);
        } else {
            this.stringBuilder.append(version);
        }
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x40000);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(signature);
        this.stringBuilder.append(", ");
        this.appendConstant(superName);
        this.stringBuilder.append(", ");
        if (interfaces != null && interfaces.length > 0) {
            this.stringBuilder.append("new String[] {");
            for (int i = 0; i < interfaces.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(interfaces[i]);
            }
            this.stringBuilder.append(" }");
        } else {
            this.stringBuilder.append("null");
        }
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitSource(String file, String debug) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitSource(");
        this.appendConstant(file);
        this.stringBuilder.append(", ");
        this.appendConstant(debug);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitModule(String name, int flags, String version) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("ModuleVisitor moduleVisitor = classWriter.visitModule(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(flags | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(version);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier("moduleVisitor", 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public void visitNestHostExperimental(String nestHost) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitNestHostExperimental(");
        this.appendConstant(nestHost);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitOuterClass(String owner, String name, String descriptor) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitOuterClass(");
        this.appendConstant(owner);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitClassAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    @Override
    public ASMifier visitClassTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    @Override
    public void visitClassAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitNestMemberExperimental(String nestMember) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitNestMemberExperimental(");
        this.appendConstant(nestMember);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("classWriter.visitInnerClass(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(outerName);
        this.stringBuilder.append(", ");
        this.appendConstant(innerName);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x100000);
        this.stringBuilder.append(END_PARAMETERS);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitField(int access, String name, String descriptor, String signature, Object value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("fieldVisitor = classWriter.visitField(");
        this.appendAccessFlags(access | 0x80000);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(signature);
        this.stringBuilder.append(", ");
        this.appendConstant(value);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier("fieldVisitor", 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public ASMifier visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("methodVisitor = classWriter.visitMethod(");
        this.appendAccessFlags(access);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(signature);
        this.stringBuilder.append(", ");
        if (exceptions != null && exceptions.length > 0) {
            this.stringBuilder.append("new String[] {");
            for (int i = 0; i < exceptions.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(exceptions[i]);
            }
            this.stringBuilder.append(" }");
        } else {
            this.stringBuilder.append("null");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier("methodVisitor", 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public void visitClassEnd() {
        this.text.add("classWriter.visitEnd();\n\n");
        this.text.add("return classWriter.toByteArray();\n");
        this.text.add("}\n");
        this.text.add("}\n");
    }

    @Override
    public void visitMainClass(String mainClass) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitMainClass(");
        this.appendConstant(mainClass);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitPackage(String packaze) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitPackage(");
        this.appendConstant(packaze);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitRequire(");
        this.appendConstant(module);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x200000);
        this.stringBuilder.append(", ");
        this.appendConstant(version);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitExport(String packaze, int access, String ... modules) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitExport(");
        this.appendConstant(packaze);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x200000);
        if (modules != null && modules.length > 0) {
            this.stringBuilder.append(", new String[] {");
            for (int i = 0; i < modules.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(modules[i]);
            }
            this.stringBuilder.append(" }");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitOpen(String packaze, int access, String ... modules) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitOpen(");
        this.appendConstant(packaze);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access | 0x200000);
        if (modules != null && modules.length > 0) {
            this.stringBuilder.append(", new String[] {");
            for (int i = 0; i < modules.length; ++i) {
                this.stringBuilder.append(i == 0 ? " " : ", ");
                this.appendConstant(modules[i]);
            }
            this.stringBuilder.append(" }");
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitUse(String service) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitUse(");
        this.appendConstant(service);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("moduleVisitor.visitProvide(");
        this.appendConstant(service);
        this.stringBuilder.append(",  new String[] {");
        for (int i = 0; i < providers.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendConstant(providers[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitModuleEnd() {
        this.text.add("moduleVisitor.visitEnd();\n");
    }

    @Override
    public void visit(String name, Object value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visit(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(value);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitEnum(String name, String descriptor, String value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(".visitEnum(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(value);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitAnnotation(String name, String descriptor) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitAnnotation(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public ASMifier visitArray(String name) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n");
        this.stringBuilder.append("AnnotationVisitor annotationVisitor").append(this.id + 1).append(" = annotationVisitor");
        this.stringBuilder.append(this.id).append(".visitArray(");
        this.appendConstant(name);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, this.id + 1);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public void visitAnnotationEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(ANNOTATION_VISITOR).append(this.id).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitFieldAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    @Override
    public ASMifier visitFieldTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    @Override
    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitFieldEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitParameter(String parameterName, int access) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitParameter(");
        ASMifier.appendString(this.stringBuilder, parameterName);
        this.stringBuilder.append(", ");
        this.appendAccessFlags(access);
        this.text.add(this.stringBuilder.append(");\n").toString());
    }

    @Override
    public ASMifier visitAnnotationDefault() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitAnnotationDefault();\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public ASMifier visitMethodAnnotation(String descriptor, boolean visible) {
        return this.visitAnnotation(descriptor, visible);
    }

    @Override
    public ASMifier visitMethodTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    @Override
    public ASMifier visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitAnnotableParameterCount(").append(parameterCount).append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    @Override
    public ASMifier visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitParameterAnnotation(").append(parameter).append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public void visitMethodAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        this.text.add(this.name + ".visitCode();\n");
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.stringBuilder.setLength(0);
        switch (type) {
            case -1: 
            case 0: {
                this.declareFrameTypes(nLocal, local);
                this.declareFrameTypes(nStack, stack);
                if (type == -1) {
                    this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_NEW, ");
                } else {
                    this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_FULL, ");
                }
                this.stringBuilder.append(nLocal).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(nLocal, local);
                this.stringBuilder.append("}, ").append(nStack).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(nStack, stack);
                this.stringBuilder.append('}');
                break;
            }
            case 1: {
                this.declareFrameTypes(nLocal, local);
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_APPEND,").append(nLocal).append(NEW_OBJECT_ARRAY);
                this.appendFrameTypes(nLocal, local);
                this.stringBuilder.append("}, 0, null");
                break;
            }
            case 2: {
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_CHOP,").append(nLocal).append(", null, 0, null");
                break;
            }
            case 3: {
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_SAME, 0, null, 0, null");
                break;
            }
            case 4: {
                this.declareFrameTypes(1, stack);
                this.stringBuilder.append(this.name).append(".visitFrame(Opcodes.F_SAME1, 0, null, 1, new Object[] {");
                this.appendFrameTypes(1, stack);
                this.stringBuilder.append('}');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInsn(int opcode) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitInsn(").append(OPCODES[opcode]).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitIntInsn(").append(OPCODES[opcode]).append(", ").append(opcode == 188 ? TYPES[operand] : Integer.toString(operand)).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitVarInsn(").append(OPCODES[opcode]).append(", ").append(var).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitTypeInsn(").append(OPCODES[opcode]).append(", ");
        this.appendConstant(type);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitFieldInsn(").append(OPCODES[opcode]).append(", ");
        this.appendConstant(owner);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        if (this.api >= 327680) {
            super.visitMethodInsn(opcode, owner, name, descriptor);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name, descriptor, opcode == 185);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        if (this.api < 327680) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    private void doVisitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMethodInsn(").append(OPCODES[opcode]).append(", ");
        this.appendConstant(owner);
        this.stringBuilder.append(", ");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.stringBuilder.append(isInterface ? "true" : "false");
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitInvokeDynamicInsn(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(bootstrapMethodHandle);
        this.stringBuilder.append(", new Object[]{");
        for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
            this.appendConstant(bootstrapMethodArguments[i]);
            if (i == bootstrapMethodArguments.length - 1) continue;
            this.stringBuilder.append(", ");
        }
        this.stringBuilder.append("});\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitJumpInsn(").append(OPCODES[opcode]).append(", ");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLabel(Label label) {
        this.stringBuilder.setLength(0);
        this.declareLabel(label);
        this.stringBuilder.append(this.name).append(".visitLabel(");
        this.appendLabel(label);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLdcInsn(");
        this.appendConstant(value);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitIincInsn(").append(var).append(", ").append(increment).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        int i;
        this.stringBuilder.setLength(0);
        for (i = 0; i < labels.length; ++i) {
            this.declareLabel(labels[i]);
        }
        this.declareLabel(dflt);
        this.stringBuilder.append(this.name).append(".visitTableSwitchInsn(").append(min).append(", ").append(max).append(", ");
        this.appendLabel(dflt);
        this.stringBuilder.append(", new Label[] {");
        for (i = 0; i < labels.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(labels[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        int i;
        this.stringBuilder.setLength(0);
        for (i = 0; i < labels.length; ++i) {
            this.declareLabel(labels[i]);
        }
        this.declareLabel(dflt);
        this.stringBuilder.append(this.name).append(".visitLookupSwitchInsn(");
        this.appendLabel(dflt);
        this.stringBuilder.append(", new int[] {");
        for (i = 0; i < keys.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ").append(keys[i]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (i = 0; i < labels.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(labels[i]);
        }
        this.stringBuilder.append(END_ARRAY);
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMultiANewArrayInsn(");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(numDimensions).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation("visitInsnAnnotation", typeRef, typePath, descriptor, visible);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.stringBuilder.setLength(0);
        this.declareLabel(start);
        this.declareLabel(end);
        this.declareLabel(handler);
        this.stringBuilder.append(this.name).append(".visitTryCatchBlock(");
        this.appendLabel(start);
        this.stringBuilder.append(", ");
        this.appendLabel(end);
        this.stringBuilder.append(", ");
        this.appendLabel(handler);
        this.stringBuilder.append(", ");
        this.appendConstant(type);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public ASMifier visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation("visitTryCatchAnnotation", typeRef, typePath, descriptor, visible);
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLocalVariable(");
        this.appendConstant(name);
        this.stringBuilder.append(", ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ");
        this.appendConstant(signature);
        this.stringBuilder.append(", ");
        this.appendLabel(start);
        this.stringBuilder.append(", ");
        this.appendLabel(end);
        this.stringBuilder.append(", ").append(index).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        int i;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitLocalVariableAnnotation(").append(typeRef);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.stringBuilder.append("new Label[] {");
        for (i = 0; i < start.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(start[i]);
        }
        this.stringBuilder.append(" }, new Label[] {");
        for (i = 0; i < end.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ");
            this.appendLabel(end[i]);
        }
        this.stringBuilder.append(" }, new int[] {");
        for (i = 0; i < index.length; ++i) {
            this.stringBuilder.append(i == 0 ? " " : ", ").append(index[i]);
        }
        this.stringBuilder.append(" }, ");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitLineNumber(").append(line).append(", ");
        this.appendLabel(start);
        this.stringBuilder.append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(".visitMaxs(").append(maxStack).append(", ").append(maxLocals).append(");\n");
        this.text.add(this.stringBuilder.toString());
    }

    @Override
    public void visitMethodEnd() {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.name).append(VISIT_END);
        this.text.add(this.stringBuilder.toString());
    }

    public ASMifier visitAnnotation(String descriptor, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".visitAnnotation(");
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public ASMifier visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return this.visitTypeAnnotation("visitTypeAnnotation", typeRef, typePath, descriptor, visible);
    }

    public ASMifier visitTypeAnnotation(String method, int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("{\n").append(ANNOTATION_VISITOR0).append(this.name).append(".").append(method).append("(").append(typeRef);
        if (typePath == null) {
            this.stringBuilder.append(", null, ");
        } else {
            this.stringBuilder.append(", TypePath.fromString(\"").append(typePath).append("\"), ");
        }
        this.appendConstant(descriptor);
        this.stringBuilder.append(", ").append(visible).append(");\n");
        this.text.add(this.stringBuilder.toString());
        ASMifier asmifier = this.createASMifier(ANNOTATION_VISITOR, 0);
        this.text.add(asmifier.getText());
        this.text.add("}\n");
        return asmifier;
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// ATTRIBUTE ").append(attribute.type).append('\n');
        if (attribute instanceof ASMifiable) {
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            this.stringBuilder.append("{\n");
            StringBuffer stringBuffer = new StringBuffer();
            ((ASMifiable)((Object)attribute)).asmify(stringBuffer, "attribute", this.labelNames);
            this.stringBuilder.append(stringBuffer.toString());
            this.stringBuilder.append(this.name).append(".visitAttribute(attribute);\n");
            this.stringBuilder.append("}\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    protected ASMifier createASMifier(String visitorVariableName, int annotationVisitorId) {
        return new ASMifier(393216, visitorVariableName, annotationVisitorId);
    }

    private void appendAccessFlags(int accessFlags) {
        boolean isEmpty = true;
        if ((accessFlags & 1) != 0) {
            this.stringBuilder.append("ACC_PUBLIC");
            isEmpty = false;
        }
        if ((accessFlags & 2) != 0) {
            this.stringBuilder.append("ACC_PRIVATE");
            isEmpty = false;
        }
        if ((accessFlags & 4) != 0) {
            this.stringBuilder.append("ACC_PROTECTED");
            isEmpty = false;
        }
        if ((accessFlags & 0x10) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x200000) == 0) {
                this.stringBuilder.append("ACC_FINAL");
            } else {
                this.stringBuilder.append("ACC_TRANSITIVE");
            }
            isEmpty = false;
        }
        if ((accessFlags & 8) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STATIC");
            isEmpty = false;
        }
        if ((accessFlags & 0x20) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x40000) == 0) {
                if ((accessFlags & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_SYNCHRONIZED");
                } else {
                    this.stringBuilder.append("ACC_TRANSITIVE");
                }
            } else {
                this.stringBuilder.append("ACC_SUPER");
            }
            isEmpty = false;
        }
        if ((accessFlags & 0x40) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x80000) == 0) {
                if ((accessFlags & 0x200000) == 0) {
                    this.stringBuilder.append("ACC_BRIDGE");
                } else {
                    this.stringBuilder.append("ACC_STATIC_PHASE");
                }
            } else {
                this.stringBuilder.append("ACC_VOLATILE");
            }
            isEmpty = false;
        }
        if ((accessFlags & 0x80) != 0 && (accessFlags & 0xC0000) == 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_VARARGS");
            isEmpty = false;
        }
        if ((accessFlags & 0x80) != 0 && (accessFlags & 0x80000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_TRANSIENT");
            isEmpty = false;
        }
        if ((accessFlags & 0x100) != 0 && (accessFlags & 0xC0000) == 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_NATIVE");
            isEmpty = false;
        }
        if ((accessFlags & 0x4000) != 0 && (accessFlags & 0x1C0000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ENUM");
            isEmpty = false;
        }
        if ((accessFlags & 0x2000) != 0 && (accessFlags & 0x140000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ANNOTATION");
            isEmpty = false;
        }
        if ((accessFlags & 0x400) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_ABSTRACT");
            isEmpty = false;
        }
        if ((accessFlags & 0x200) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_INTERFACE");
            isEmpty = false;
        }
        if ((accessFlags & 0x800) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_STRICT");
            isEmpty = false;
        }
        if ((accessFlags & 0x1000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_SYNTHETIC");
            isEmpty = false;
        }
        if ((accessFlags & 0x20000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            this.stringBuilder.append("ACC_DEPRECATED");
            isEmpty = false;
        }
        if ((accessFlags & 0x8000) != 0) {
            if (!isEmpty) {
                this.stringBuilder.append(" | ");
            }
            if ((accessFlags & 0x40000) == 0) {
                this.stringBuilder.append("ACC_MANDATED");
            } else {
                this.stringBuilder.append("ACC_MODULE");
            }
            isEmpty = false;
        }
        if (isEmpty) {
            this.stringBuilder.append('0');
        }
    }

    protected void appendConstant(Object value) {
        if (value == null) {
            this.stringBuilder.append("null");
        } else if (value instanceof String) {
            ASMifier.appendString(this.stringBuilder, (String)value);
        } else if (value instanceof Type) {
            this.stringBuilder.append("Type.getType(\"");
            this.stringBuilder.append(((Type)value).getDescriptor());
            this.stringBuilder.append("\")");
        } else if (value instanceof Handle) {
            this.stringBuilder.append("new Handle(");
            Handle handle = (Handle)value;
            this.stringBuilder.append("Opcodes.").append(HANDLE_TAG[handle.getTag()]).append(", \"");
            this.stringBuilder.append(handle.getOwner()).append("\", \"");
            this.stringBuilder.append(handle.getName()).append("\", \"");
            this.stringBuilder.append(handle.getDesc()).append("\", ");
            this.stringBuilder.append(handle.isInterface()).append(")");
        } else if (value instanceof ConstantDynamic) {
            this.stringBuilder.append("new ConstantDynamic(\"");
            ConstantDynamic constantDynamic = (ConstantDynamic)value;
            this.stringBuilder.append(constantDynamic.getName()).append("\", \"");
            this.stringBuilder.append(constantDynamic.getDescriptor()).append("\", ");
            this.appendConstant(constantDynamic.getBootstrapMethod());
            this.stringBuilder.append(NEW_OBJECT_ARRAY);
            Object[] bootstrapMethodArguments = constantDynamic.getBootstrapMethodArguments();
            for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                this.appendConstant(bootstrapMethodArguments[i]);
                if (i == bootstrapMethodArguments.length - 1) continue;
                this.stringBuilder.append(", ");
            }
            this.stringBuilder.append("})");
        } else if (value instanceof Byte) {
            this.stringBuilder.append("new Byte((byte)").append(value).append(')');
        } else if (value instanceof Boolean) {
            this.stringBuilder.append((Boolean)value != false ? "Boolean.TRUE" : "Boolean.FALSE");
        } else if (value instanceof Short) {
            this.stringBuilder.append("new Short((short)").append(value).append(')');
        } else if (value instanceof Character) {
            this.stringBuilder.append("new Character((char)").append((int)((Character)value).charValue()).append(')');
        } else if (value instanceof Integer) {
            this.stringBuilder.append("new Integer(").append(value).append(')');
        } else if (value instanceof Float) {
            this.stringBuilder.append("new Float(\"").append(value).append("\")");
        } else if (value instanceof Long) {
            this.stringBuilder.append("new Long(").append(value).append("L)");
        } else if (value instanceof Double) {
            this.stringBuilder.append("new Double(\"").append(value).append("\")");
        } else if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            this.stringBuilder.append("new byte[] {");
            for (int i = 0; i < byteArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(byteArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])value;
            this.stringBuilder.append("new boolean[] {");
            for (int i = 0; i < booleanArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(booleanArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof short[]) {
            short[] shortArray = (short[])value;
            this.stringBuilder.append("new short[] {");
            for (int i = 0; i < shortArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append("(short)").append(shortArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof char[]) {
            char[] charArray = (char[])value;
            this.stringBuilder.append("new char[] {");
            for (int i = 0; i < charArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append("(char)").append((int)charArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof int[]) {
            int[] intArray = (int[])value;
            this.stringBuilder.append("new int[] {");
            for (int i = 0; i < intArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(intArray[i]);
            }
            this.stringBuilder.append('}');
        } else if (value instanceof long[]) {
            long[] longArray = (long[])value;
            this.stringBuilder.append("new long[] {");
            for (int i = 0; i < longArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(longArray[i]).append('L');
            }
            this.stringBuilder.append('}');
        } else if (value instanceof float[]) {
            float[] floatArray = (float[])value;
            this.stringBuilder.append("new float[] {");
            for (int i = 0; i < floatArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(floatArray[i]).append('f');
            }
            this.stringBuilder.append('}');
        } else if (value instanceof double[]) {
            double[] doubleArray = (double[])value;
            this.stringBuilder.append("new double[] {");
            for (int i = 0; i < doubleArray.length; ++i) {
                this.stringBuilder.append(i == 0 ? "" : ",").append(doubleArray[i]).append('d');
            }
            this.stringBuilder.append('}');
        }
    }

    private void declareFrameTypes(int nTypes, Object[] frameTypes) {
        for (int i = 0; i < nTypes; ++i) {
            if (!(frameTypes[i] instanceof Label)) continue;
            this.declareLabel((Label)frameTypes[i]);
        }
    }

    private void appendFrameTypes(int nTypes, Object[] frameTypes) {
        block9: for (int i = 0; i < nTypes; ++i) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            if (frameTypes[i] instanceof String) {
                this.appendConstant(frameTypes[i]);
                continue;
            }
            if (frameTypes[i] instanceof Integer) {
                switch ((Integer)frameTypes[i]) {
                    case 0: {
                        this.stringBuilder.append("Opcodes.TOP");
                        continue block9;
                    }
                    case 1: {
                        this.stringBuilder.append("Opcodes.INTEGER");
                        continue block9;
                    }
                    case 2: {
                        this.stringBuilder.append("Opcodes.FLOAT");
                        continue block9;
                    }
                    case 3: {
                        this.stringBuilder.append("Opcodes.DOUBLE");
                        continue block9;
                    }
                    case 4: {
                        this.stringBuilder.append("Opcodes.LONG");
                        continue block9;
                    }
                    case 5: {
                        this.stringBuilder.append("Opcodes.NULL");
                        continue block9;
                    }
                    case 6: {
                        this.stringBuilder.append("Opcodes.UNINITIALIZED_THIS");
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.appendLabel((Label)frameTypes[i]);
        }
    }

    protected void declareLabel(Label label) {
        String labelName;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((labelName = this.labelNames.get(label)) == null) {
            labelName = "label" + this.labelNames.size();
            this.labelNames.put(label, labelName);
            this.stringBuilder.append("Label ").append(labelName).append(" = new Label();\n");
        }
    }

    protected void appendLabel(Label label) {
        this.stringBuilder.append(this.labelNames.get(label));
    }

    static {
        HashMap<Integer, String> classVersions = new HashMap<Integer, String>();
        classVersions.put(196653, "V1_1");
        classVersions.put(46, "V1_2");
        classVersions.put(47, "V1_3");
        classVersions.put(48, "V1_4");
        classVersions.put(49, "V1_5");
        classVersions.put(50, "V1_6");
        classVersions.put(51, "V1_7");
        classVersions.put(52, "V1_8");
        classVersions.put(53, "V9");
        classVersions.put(54, "V10");
        classVersions.put(55, "V11");
        CLASS_VERSIONS = Collections.unmodifiableMap(classVersions);
    }
}

