/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.spring.SpringObjectFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;

public class SpringProxyableObjectFactory
extends SpringObjectFactory {
    private static final Logger LOG = LogManager.getLogger(SpringProxyableObjectFactory.class);
    private List<String> skipBeanNames = new ArrayList<String>();

    public Object buildBean(String beanName, Map<String, Object> extraContext) throws Exception {
        block7: {
            LOG.debug("Building bean for name {}", (Object)beanName);
            if (!this.skipBeanNames.contains(beanName)) {
                ApplicationContext anAppContext = this.getApplicationContext(extraContext);
                try {
                    LOG.debug("Trying the application context... appContext = {},\n bean name = {}", (Object)anAppContext, (Object)beanName);
                    return anAppContext.getBean(beanName);
                }
                catch (NoSuchBeanDefinitionException e) {
                    LOG.debug("Did not find bean definition for bean named {}, creating a new one...", (Object)beanName);
                    if (!(this.autoWiringFactory instanceof BeanDefinitionRegistry)) break block7;
                    try {
                        Class<?> clazz = Class.forName(beanName);
                        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.autoWiringFactory;
                        RootBeanDefinition def = new RootBeanDefinition(clazz, this.autowireStrategy, true);
                        def.setScope("singleton");
                        LOG.debug("Registering a new bean definition for class {}", (Object)beanName);
                        registry.registerBeanDefinition(beanName, (BeanDefinition)def);
                        try {
                            return anAppContext.getBean(beanName);
                        }
                        catch (NoSuchBeanDefinitionException e2) {
                            LOG.warn("Could not register new bean definition for bean {}", (Object)beanName);
                            this.skipBeanNames.add(beanName);
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        this.skipBeanNames.add(beanName);
                    }
                }
            }
        }
        LOG.debug("Returning autowired instance created by default ObjectFactory");
        return this.autoWireBean(super.buildBean(beanName, extraContext), this.autoWiringFactory);
    }

    protected ApplicationContext getApplicationContext(Map<String, Object> context) {
        return this.appContext;
    }
}

