/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import jakarta.servlet.http.Cookie;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class CookieResultMatchers {
    protected CookieResultMatchers() {
    }

    public ResultMatcher value(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat((String)("Response cookie '" + name + "'"), (Object)cookie.getValue(), (Matcher)matcher);
        };
    }

    public ResultMatcher value(String name, String expectedValue) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie", expectedValue, cookie.getValue());
        };
    }

    public ResultMatcher exists(String name) {
        return result -> CookieResultMatchers.getCookie(result, name);
    }

    public ResultMatcher doesNotExist(String name) {
        return result -> {
            Cookie cookie = result.getResponse().getCookie(name);
            AssertionErrors.assertNull("Unexpected cookie with name '" + name + "'", cookie);
        };
    }

    public ResultMatcher maxAge(String name, Matcher<? super Integer> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat((String)("Response cookie '" + name + "' maxAge"), (Object)cookie.getMaxAge(), (Matcher)matcher);
        };
    }

    public ResultMatcher maxAge(String name, int maxAge) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' maxAge", maxAge, cookie.getMaxAge());
        };
    }

    public ResultMatcher path(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat((String)("Response cookie '" + name + "' path"), (Object)cookie.getPath(), (Matcher)matcher);
        };
    }

    public ResultMatcher path(String name, String path) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' path", path, cookie.getPath());
        };
    }

    public ResultMatcher domain(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat((String)("Response cookie '" + name + "' domain"), (Object)cookie.getDomain(), (Matcher)matcher);
        };
    }

    public ResultMatcher domain(String name, String domain) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' domain", domain, cookie.getDomain());
        };
    }

    public ResultMatcher sameSite(String name, Matcher<? super String> matcher) {
        return this.attribute(name, "SameSite", matcher);
    }

    public ResultMatcher sameSite(String name, String sameSite) {
        return this.attribute(name, "SameSite", sameSite);
    }

    public ResultMatcher comment(String name, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat((String)("Response cookie '" + name + "' comment"), (Object)cookie.getComment(), (Matcher)matcher);
        };
    }

    public ResultMatcher comment(String name, String comment) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' comment", comment, cookie.getComment());
        };
    }

    public ResultMatcher version(String name, Matcher<? super Integer> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            MatcherAssert.assertThat((String)("Response cookie '" + name + "' version"), (Object)cookie.getVersion(), (Matcher)matcher);
        };
    }

    public ResultMatcher version(String name, int version) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' version", version, cookie.getVersion());
        };
    }

    public ResultMatcher secure(String name, boolean secure) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' secure", secure, cookie.getSecure());
        };
    }

    public ResultMatcher httpOnly(String name, boolean httpOnly) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' httpOnly", httpOnly, cookie.isHttpOnly());
        };
    }

    public ResultMatcher partitioned(String name, boolean partitioned) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, name);
            AssertionErrors.assertEquals("Response cookie '" + name + "' partitioned", partitioned, cookie.getAttribute("Partitioned") != null);
        };
    }

    public ResultMatcher attribute(String cookieName, String cookieAttribute, Matcher<? super String> matcher) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, cookieName);
            String attribute = cookie.getAttribute(cookieAttribute);
            AssertionErrors.assertNotNull("Response cookie '" + cookieName + "' doesn't have attribute '" + cookieAttribute + "'", attribute);
            MatcherAssert.assertThat((String)("Response cookie '" + cookieName + "' attribute '" + cookieAttribute + "'"), (Object)attribute, (Matcher)matcher);
        };
    }

    public ResultMatcher attribute(String cookieName, String cookieAttribute, String attributeValue) {
        return result -> {
            Cookie cookie = CookieResultMatchers.getCookie(result, cookieName);
            AssertionErrors.assertEquals("Response cookie '" + cookieName + "' attribute '" + cookieAttribute + "'", attributeValue, cookie.getAttribute(cookieAttribute));
        };
    }

    private static Cookie getCookie(MvcResult result, String name) {
        Cookie cookie = result.getResponse().getCookie(name);
        AssertionErrors.assertNotNull("No cookie with name '" + name + "'", cookie);
        return cookie;
    }
}

