/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRCommonImage;
import net.sf.jasperreports.engine.JRCommonRectangle;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRParagraphContainer;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;

public class StyleResolver {
    public static final String PROPERTY_STYLES_INHERIT_FROM_DEFAULT = "net.sf.jasperreports.styles.inherit.from.default";
    private static final StyleResolver INSTANCE = new StyleResolver(DefaultJasperReportsContext.getInstance());
    private static final Integer INTEGER_ZERO = 0;
    private final JRPropertiesUtil propertiesUtil;
    private final Boolean stylesInheritFromDefault;

    public StyleResolver(JasperReportsContext jasperReportsContext) {
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.stylesInheritFromDefault = this.propertiesUtil.getBooleanProperty(PROPERTY_STYLES_INHERIT_FROM_DEFAULT);
    }

    public static StyleResolver getInstance() {
        return INSTANCE;
    }

    public JRStyle getBaseStyle(JRStyle styleContainer) {
        if (styleContainer != null) {
            JRDefaultStyleProvider defaultStyleProvider;
            JRStyle style = styleContainer.getStyle();
            if (style != null) {
                return style;
            }
            if (this.stylesInheritFromDefault.booleanValue() && !styleContainer.isDefault() && (defaultStyleProvider = styleContainer.getDefaultStyleProvider()) != null) {
                return defaultStyleProvider.getDefaultStyle();
            }
        }
        return null;
    }

    public JRStyle getBaseStyle(JRLineBox box) {
        if (box != null) {
            JRBoxContainer boxContainer = box.getBoxContainer();
            if (boxContainer instanceof JRStyle) {
                return this.getBaseStyle((JRStyle)boxContainer);
            }
            return this.getBaseStyle(boxContainer);
        }
        return null;
    }

    public JRStyle getBaseStyle(JRPen pen) {
        if (pen != null) {
            JRPenContainer penContainer = pen.getPenContainer();
            if (penContainer instanceof JRStyle) {
                return this.getBaseStyle((JRStyle)penContainer);
            }
            if (penContainer instanceof JRLineBox) {
                return this.getBaseStyle((JRLineBox)penContainer);
            }
            return this.getBaseStyle(penContainer);
        }
        return null;
    }

    public JRStyle getBaseStyle(JRParagraph paragraph) {
        if (paragraph != null) {
            JRParagraphContainer paragraphContainer = paragraph.getParagraphContainer();
            if (paragraphContainer instanceof JRStyle) {
                return this.getBaseStyle((JRStyle)paragraphContainer);
            }
            return this.getBaseStyle(paragraphContainer);
        }
        return null;
    }

    public JRStyle getBaseStyle(JRStyleContainer styleContainer) {
        if (styleContainer != null) {
            if (styleContainer instanceof JRStyle) {
                return this.getBaseStyle((JRStyle)styleContainer);
            }
            return StyleResolver.getBaseStyleFromStyleContainer(styleContainer);
        }
        return null;
    }

    protected static JRStyle getBaseStyleFromStyleContainer(JRStyleContainer styleContainer) {
        if (styleContainer != null) {
            JRStyle style = styleContainer.getStyle();
            if (style != null) {
                return style;
            }
            JRDefaultStyleProvider defaultStyleProvider = styleContainer.getDefaultStyleProvider();
            if (defaultStyleProvider != null) {
                return defaultStyleProvider.getDefaultStyle();
            }
        }
        return null;
    }

    public ModeEnum getMode(JRCommonElement element, ModeEnum defaultMode) {
        ModeEnum mode;
        ModeEnum ownMode = element.getOwnMode();
        if (ownMode != null) {
            return ownMode;
        }
        JRStyle style = this.getBaseStyle(element);
        if (style != null && (mode = style.getMode()) != null) {
            return mode;
        }
        return defaultMode;
    }

    public ModeEnum getModeValue(JRStyle style) {
        ModeEnum ownMode = style.getOwnMode();
        if (ownMode != null) {
            return ownMode;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getMode();
        }
        return null;
    }

    public Color getForecolor(JRCommonElement element) {
        Color forecolor;
        Color ownForecolor = element.getOwnForecolor();
        if (ownForecolor != null) {
            return ownForecolor;
        }
        JRStyle style = this.getBaseStyle(element);
        if (style != null && (forecolor = style.getForecolor()) != null) {
            return forecolor;
        }
        return Color.black;
    }

    public Color getForecolor(JRStyle style) {
        Color ownForecolor = style.getOwnForecolor();
        if (ownForecolor != null) {
            return ownForecolor;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getForecolor();
        }
        return null;
    }

    public Color getBackcolor(JRCommonElement element) {
        Color backcolor;
        Color ownBackcolor = element.getOwnBackcolor();
        if (ownBackcolor != null) {
            return ownBackcolor;
        }
        JRStyle style = this.getBaseStyle(element);
        if (style != null && (backcolor = style.getBackcolor()) != null) {
            return backcolor;
        }
        return Color.white;
    }

    public Color getBackcolor(JRStyle style) {
        Color ownBackcolor = style.getOwnBackcolor();
        if (ownBackcolor != null) {
            return ownBackcolor;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getBackcolor();
        }
        return null;
    }

    public Float getLineWidth(JRPen pen, Float defaultLineWidth) {
        Float lineWidth;
        Float ownLineWidth = pen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        JRStyle baseStyle = this.getBaseStyle(pen);
        if (baseStyle != null && (lineWidth = baseStyle.getLinePen().getLineWidth()) != null) {
            return lineWidth;
        }
        return defaultLineWidth;
    }

    public Float getLineWidth(JRBoxPen boxPen, Float defaultLineWidth) {
        Float ownLineWidth = boxPen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        Float penLineWidth = boxPen.getBox().getPen().getOwnLineWidth();
        if (penLineWidth != null) {
            return penLineWidth;
        }
        return this.getParentLineWidth(boxPen, defaultLineWidth);
    }

    public Float getParentLineWidth(JRBoxPen boxPen, Float defaultLineWidth) {
        Float lineWidth;
        JRStyle baseStyle = this.getBaseStyle(boxPen);
        if (baseStyle != null && (lineWidth = boxPen.getPen(baseStyle.getLineBox()).getLineWidth()) != null) {
            return lineWidth;
        }
        return defaultLineWidth;
    }

    public LineStyleEnum getLineStyle(JRPen pen) {
        LineStyleEnum lineStyle;
        LineStyleEnum ownLineStyle = pen.getOwnLineStyle();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        JRStyle baseStyle = this.getBaseStyle(pen);
        if (baseStyle != null && (lineStyle = baseStyle.getLinePen().getLineStyle()) != null) {
            return lineStyle;
        }
        return LineStyleEnum.SOLID;
    }

    public LineStyleEnum getLineStyle(JRBoxPen boxPen) {
        LineStyleEnum ownLineStyle = boxPen.getOwnLineStyle();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        LineStyleEnum penLineStyle = boxPen.getBox().getPen().getOwnLineStyle();
        if (penLineStyle != null) {
            return penLineStyle;
        }
        return this.getParentLineStyle(boxPen);
    }

    public LineStyleEnum getParentLineStyle(JRBoxPen boxPen) {
        LineStyleEnum lineStyle;
        JRStyle baseStyle = this.getBaseStyle(boxPen);
        if (baseStyle != null && (lineStyle = boxPen.getPen(baseStyle.getLineBox()).getLineStyle()) != null) {
            return lineStyle;
        }
        return LineStyleEnum.SOLID;
    }

    public Color getLineColor(JRPen pen, Color defaultColor) {
        Color lineColor;
        Color ownLineColor = pen.getOwnLineColor();
        if (ownLineColor != null) {
            return ownLineColor;
        }
        JRStyle baseStyle = this.getBaseStyle(pen);
        if (baseStyle != null && (lineColor = baseStyle.getLinePen().getLineColor()) != null) {
            return lineColor;
        }
        return defaultColor;
    }

    public Color getLineColor(JRBoxPen boxPen, Color defaultColor) {
        Color ownLineColor = boxPen.getOwnLineColor();
        if (ownLineColor != null) {
            return ownLineColor;
        }
        Color penLineColor = boxPen.getBox().getPen().getOwnLineColor();
        if (penLineColor != null) {
            return penLineColor;
        }
        return this.getParentLineColor(boxPen, defaultColor);
    }

    public Color getParentLineColor(JRBoxPen boxPen, Color defaultColor) {
        Color lineColor;
        JRStyle baseStyle = this.getBaseStyle(boxPen);
        if (baseStyle != null && (lineColor = boxPen.getPen(baseStyle.getLineBox()).getLineColor()) != null) {
            return lineColor;
        }
        return defaultColor;
    }

    public FillEnum getFill(JRCommonGraphicElement element) {
        FillEnum fill;
        FillEnum ownFill = element.getOwnFill();
        if (ownFill != null) {
            return ownFill;
        }
        JRStyle baseStyle = this.getBaseStyle(element);
        if (baseStyle != null && (fill = baseStyle.getFill()) != null) {
            return fill;
        }
        return FillEnum.SOLID;
    }

    public FillEnum getFill(JRStyle style) {
        FillEnum ownFill = style.getOwnFill();
        if (ownFill != null) {
            return ownFill;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getFill();
        }
        return null;
    }

    public int getRadius(JRCommonRectangle rectangle) {
        Integer radius;
        Integer ownRadius = rectangle.getOwnRadius();
        if (ownRadius != null) {
            return ownRadius;
        }
        JRStyle baseStyle = this.getBaseStyle(rectangle);
        if (baseStyle != null && (radius = baseStyle.getRadius()) != null) {
            return radius;
        }
        return 0;
    }

    public Integer getRadius(JRStyle style) {
        Integer ownRadius = style.getOwnRadius();
        if (ownRadius != null) {
            return ownRadius;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getRadius();
        }
        return null;
    }

    public ScaleImageEnum getScaleImage(JRCommonImage image) {
        ScaleImageEnum scaleImage;
        ScaleImageEnum ownScaleImage = image.getOwnScaleImage();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = this.getBaseStyle(image);
        if (baseStyle != null && (scaleImage = baseStyle.getScaleImage()) != null) {
            return scaleImage;
        }
        return ScaleImageEnum.RETAIN_SHAPE;
    }

    public ScaleImageEnum getScaleImage(JRStyle style) {
        ScaleImageEnum ownScaleImage = style.getOwnScaleImage();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getScaleImage();
        }
        return null;
    }

    public HorizontalTextAlignEnum getHorizontalTextAlign(JRTextAlignment alignment) {
        HorizontalTextAlignEnum horizontalAlignment;
        HorizontalTextAlignEnum ownHorizontalAlignment = alignment.getOwnHorizontalTextAlign();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(alignment);
        if (baseStyle != null && (horizontalAlignment = baseStyle.getHorizontalTextAlign()) != null) {
            return horizontalAlignment;
        }
        return HorizontalTextAlignEnum.LEFT;
    }

    public HorizontalImageAlignEnum getHorizontalImageAlign(JRImageAlignment alignment) {
        HorizontalImageAlignEnum horizontalAlignment;
        HorizontalImageAlignEnum ownHorizontalAlignment = alignment.getOwnHorizontalImageAlign();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(alignment);
        if (baseStyle != null && (horizontalAlignment = baseStyle.getHorizontalImageAlign()) != null) {
            return horizontalAlignment;
        }
        return HorizontalImageAlignEnum.LEFT;
    }

    public HorizontalTextAlignEnum getHorizontalTextAlign(JRStyle style) {
        HorizontalTextAlignEnum ownHorizontalAlignment = style.getOwnHorizontalTextAlign();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getHorizontalTextAlign();
        }
        return null;
    }

    public HorizontalImageAlignEnum getHorizontalImageAlign(JRStyle style) {
        HorizontalImageAlignEnum ownHorizontalAlignment = style.getOwnHorizontalImageAlign();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getHorizontalImageAlign();
        }
        return null;
    }

    public VerticalTextAlignEnum getVerticalTextAlign(JRTextAlignment alignment) {
        VerticalTextAlignEnum verticalAlignment;
        VerticalTextAlignEnum ownVerticalAlignment = alignment.getOwnVerticalTextAlign();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(alignment);
        if (baseStyle != null && (verticalAlignment = baseStyle.getVerticalTextAlign()) != null) {
            return verticalAlignment;
        }
        return VerticalTextAlignEnum.TOP;
    }

    public VerticalImageAlignEnum getVerticalImageAlign(JRImageAlignment alignment) {
        VerticalImageAlignEnum verticalAlignment;
        VerticalImageAlignEnum ownVerticalAlignment = alignment.getOwnVerticalImageAlign();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(alignment);
        if (baseStyle != null && (verticalAlignment = baseStyle.getVerticalImageAlign()) != null) {
            return verticalAlignment;
        }
        return VerticalImageAlignEnum.TOP;
    }

    public VerticalTextAlignEnum getVerticalTextAlign(JRStyle style) {
        VerticalTextAlignEnum ownVerticalAlignment = style.getOwnVerticalTextAlign();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getVerticalTextAlign();
        }
        return null;
    }

    public VerticalImageAlignEnum getVerticalImageAlign(JRStyle style) {
        VerticalImageAlignEnum ownVerticalAlignment = style.getOwnVerticalImageAlign();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getVerticalImageAlign();
        }
        return null;
    }

    public Float getLineSpacingSize(JRParagraph paragraph) {
        Float lineSpacingSize;
        Float ownLineSpacingSize = paragraph.getOwnLineSpacingSize();
        if (ownLineSpacingSize != null) {
            return ownLineSpacingSize;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (lineSpacingSize = style.getParagraph().getLineSpacingSize()) != null) {
            return lineSpacingSize;
        }
        return Float.valueOf(this.propertiesUtil.getFloatProperty("net.sf.jasperreports.default.line.spacing.size"));
    }

    public Integer getFirstLineIndent(JRParagraph paragraph) {
        Integer firstLineIndent;
        Integer ownFirstLineIndent = paragraph.getOwnFirstLineIndent();
        if (ownFirstLineIndent != null) {
            return ownFirstLineIndent;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (firstLineIndent = style.getParagraph().getFirstLineIndent()) != null) {
            return firstLineIndent;
        }
        return this.propertiesUtil.getIntegerProperty("net.sf.jasperreports.default.first.line.indent");
    }

    public Integer getLeftIndent(JRParagraph paragraph) {
        Integer leftIndent;
        Integer ownLeftIndent = paragraph.getOwnLeftIndent();
        if (ownLeftIndent != null) {
            return ownLeftIndent;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (leftIndent = style.getParagraph().getLeftIndent()) != null) {
            return leftIndent;
        }
        return this.propertiesUtil.getIntegerProperty("net.sf.jasperreports.default.left.indent");
    }

    public Integer getRightIndent(JRParagraph paragraph) {
        Integer rightIndent;
        Integer ownRightIndent = paragraph.getOwnRightIndent();
        if (ownRightIndent != null) {
            return ownRightIndent;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (rightIndent = style.getParagraph().getRightIndent()) != null) {
            return rightIndent;
        }
        return this.propertiesUtil.getIntegerProperty("net.sf.jasperreports.default.right.indent");
    }

    public Integer getSpacingBefore(JRParagraph paragraph) {
        Integer spacingBefore;
        Integer ownSpacingBefore = paragraph.getOwnSpacingBefore();
        if (ownSpacingBefore != null) {
            return ownSpacingBefore;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (spacingBefore = style.getParagraph().getSpacingBefore()) != null) {
            return spacingBefore;
        }
        return this.propertiesUtil.getIntegerProperty("net.sf.jasperreports.default.spacing.before");
    }

    public Integer getSpacingAfter(JRParagraph paragraph) {
        Integer spacingAfter;
        Integer ownSpacingAfter = paragraph.getOwnSpacingAfter();
        if (ownSpacingAfter != null) {
            return ownSpacingAfter;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (spacingAfter = style.getParagraph().getSpacingAfter()) != null) {
            return spacingAfter;
        }
        return this.propertiesUtil.getIntegerProperty("net.sf.jasperreports.default.spacing.after");
    }

    public Integer getTabStopWidth(JRParagraph paragraph) {
        Integer tabStopWidth;
        Integer ownTabStopWidth = paragraph.getOwnTabStopWidth();
        if (ownTabStopWidth != null) {
            return ownTabStopWidth;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (tabStopWidth = style.getParagraph().getTabStopWidth()) != null) {
            return tabStopWidth;
        }
        return this.propertiesUtil.getIntegerProperty("net.sf.jasperreports.default.tab.stop.width");
    }

    public TabStop[] getTabStops(JRParagraph paragraph) {
        TabStop[] tabStops;
        TabStop[] ownTabStops = paragraph.getOwnTabStops();
        if (ownTabStops != null) {
            return ownTabStops;
        }
        JRStyle style = this.getBaseStyle(paragraph);
        if (style != null && (tabStops = style.getParagraph().getTabStops()) != null) {
            return tabStops;
        }
        return null;
    }

    public RotationEnum getRotation(JRCommonText element) {
        RotationEnum rotation;
        RotationEnum ownRotation = element.getOwnRotation();
        if (ownRotation != null) {
            return ownRotation;
        }
        JRStyle style = this.getBaseStyle(element);
        if (style != null && (rotation = style.getRotation()) != null) {
            return rotation;
        }
        return RotationEnum.NONE;
    }

    public RotationEnum getRotation(JRCommonImage element) {
        RotationEnum rotation;
        RotationEnum ownRotation = element.getOwnRotation();
        if (ownRotation != null) {
            return ownRotation;
        }
        JRStyle style = this.getBaseStyle(element);
        if (style != null && (rotation = style.getRotation()) != null) {
            return rotation;
        }
        return RotationEnum.NONE;
    }

    public RotationEnum getRotation(JRStyle style) {
        RotationEnum ownRotation = style.getOwnRotation();
        if (ownRotation != null) {
            return ownRotation;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getRotation();
        }
        return null;
    }

    public LineSpacingEnum getLineSpacing(JRParagraph paragraph) {
        LineSpacingEnum lineSpacing;
        LineSpacingEnum ownLineSpacing = paragraph.getOwnLineSpacing();
        if (ownLineSpacing != null) {
            return ownLineSpacing;
        }
        JRStyle baseStyle = this.getBaseStyle(paragraph);
        if (baseStyle != null && (lineSpacing = baseStyle.getParagraph().getLineSpacing()) != null) {
            return lineSpacing;
        }
        return LineSpacingEnum.SINGLE;
    }

    public String getMarkup(JRCommonText element) {
        String markup;
        String ownMarkup = element.getOwnMarkup();
        if (ownMarkup != null) {
            return ownMarkup;
        }
        JRStyle baseStyle = this.getBaseStyle(element);
        if (baseStyle != null && (markup = baseStyle.getMarkup()) != null) {
            return markup;
        }
        return "none";
    }

    public String getMarkup(JRStyle style) {
        String ownMarkup = style.getOwnMarkup();
        if (ownMarkup != null) {
            return ownMarkup;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getMarkup();
        }
        return "none";
    }

    public String getPattern(JRTextField element) {
        String ownPattern = element.getOwnPattern();
        if (ownPattern != null) {
            return ownPattern;
        }
        JRStyle baseStyle = this.getBaseStyle(element);
        if (baseStyle != null) {
            return baseStyle.getPattern();
        }
        return null;
    }

    public String getPattern(JRStyle style) {
        String ownPattern = style.getOwnPattern();
        if (ownPattern != null) {
            return ownPattern;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getPattern();
        }
        return null;
    }

    public boolean isBlankWhenNull(JRTextField element) {
        Boolean blankWhenNull;
        Boolean ownBlankWhenNull = element.isOwnBlankWhenNull();
        if (ownBlankWhenNull != null) {
            return ownBlankWhenNull;
        }
        JRStyle baseStyle = this.getBaseStyle(element);
        if (baseStyle != null && (blankWhenNull = baseStyle.isBlankWhenNull()) != null) {
            return blankWhenNull;
        }
        return false;
    }

    public Boolean isBlankWhenNull(JRStyle style) {
        Boolean ownBlankWhenNull = style.isOwnBlankWhenNull();
        if (ownBlankWhenNull != null) {
            return ownBlankWhenNull;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isBlankWhenNull();
        }
        return null;
    }

    public String getFontName(JRFont font) {
        String fontName;
        String ownFontName = font.getOwnFontName();
        if (ownFontName != null) {
            return ownFontName;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (fontName = baseStyle.getFontName()) != null) {
            return fontName;
        }
        return this.propertiesUtil.getProperty("net.sf.jasperreports.default.font.name");
    }

    public String getFontName(JRStyle style) {
        String fontName;
        String ownFontName = style.getOwnFontName();
        if (ownFontName != null) {
            return ownFontName;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null && (fontName = baseStyle.getFontName()) != null) {
            return fontName;
        }
        return this.propertiesUtil.getProperty("net.sf.jasperreports.default.font.name");
    }

    public boolean isBold(JRFont font) {
        Boolean bold;
        Boolean ownBold = font.isOwnBold();
        if (ownBold != null) {
            return ownBold;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (bold = baseStyle.isBold()) != null) {
            return bold;
        }
        return false;
    }

    public Boolean isBold(JRStyle style) {
        Boolean ownBold = style.isOwnBold();
        if (ownBold != null) {
            return ownBold;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isBold();
        }
        return null;
    }

    public boolean isItalic(JRFont font) {
        Boolean italic;
        Boolean ownItalic = font.isOwnItalic();
        if (ownItalic != null) {
            return ownItalic;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (italic = baseStyle.isItalic()) != null) {
            return italic;
        }
        return false;
    }

    public Boolean isItalic(JRStyle style) {
        Boolean ownItalic = style.isOwnItalic();
        if (ownItalic != null) {
            return ownItalic;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isItalic();
        }
        return null;
    }

    public boolean isUnderline(JRFont font) {
        Boolean underline;
        Boolean ownUnderline = font.isOwnUnderline();
        if (ownUnderline != null) {
            return ownUnderline;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (underline = baseStyle.isUnderline()) != null) {
            return underline;
        }
        return false;
    }

    public Boolean isUnderline(JRStyle style) {
        Boolean ownUnderline = style.isOwnUnderline();
        if (ownUnderline != null) {
            return ownUnderline;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isUnderline();
        }
        return null;
    }

    public boolean isStrikeThrough(JRFont font) {
        Boolean strikeThrough;
        Boolean ownStrikeThrough = font.isOwnStrikeThrough();
        if (ownStrikeThrough != null) {
            return ownStrikeThrough;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (strikeThrough = baseStyle.isStrikeThrough()) != null) {
            return strikeThrough;
        }
        return false;
    }

    public Boolean isStrikeThrough(JRStyle style) {
        if (style.isOwnStrikeThrough() != null) {
            return style.isOwnStrikeThrough();
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isStrikeThrough();
        }
        return null;
    }

    public float getFontSize(JRFont font) {
        Float fontSize;
        Float ownFontSize = font.getOwnFontSize();
        if (ownFontSize != null) {
            return ownFontSize.floatValue();
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (fontSize = baseStyle.getFontSize()) != null) {
            return fontSize.floatValue();
        }
        return this.propertiesUtil.getFloatProperty("net.sf.jasperreports.default.font.size");
    }

    public Float getFontSize(JRStyle style) {
        Float ownFontSize = style.getOwnFontSize();
        if (ownFontSize != null) {
            return ownFontSize;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.getFontSize();
        }
        return null;
    }

    public String getPdfFontName(JRFont font) {
        String pdfFontName;
        String ownPdfFontName = font.getOwnPdfFontName();
        if (ownPdfFontName != null) {
            return ownPdfFontName;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (pdfFontName = baseStyle.getPdfFontName()) != null) {
            return pdfFontName;
        }
        return this.propertiesUtil.getProperty("net.sf.jasperreports.default.pdf.font.name");
    }

    public String getPdfFontName(JRStyle style) {
        String pdfFontName;
        String ownPdfFontName = style.getOwnPdfFontName();
        if (ownPdfFontName != null) {
            return ownPdfFontName;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null && (pdfFontName = baseStyle.getPdfFontName()) != null) {
            return pdfFontName;
        }
        return this.propertiesUtil.getProperty("net.sf.jasperreports.default.pdf.font.name");
    }

    public String getPdfEncoding(JRFont font) {
        String pdfEncoding;
        String ownPdfEncoding = font.getOwnPdfEncoding();
        if (ownPdfEncoding != null) {
            return ownPdfEncoding;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (pdfEncoding = baseStyle.getPdfEncoding()) != null) {
            return pdfEncoding;
        }
        return this.propertiesUtil.getProperty("net.sf.jasperreports.default.pdf.encoding");
    }

    public String getPdfEncoding(JRStyle style) {
        String pdfEncoding;
        String ownPdfEncoding = style.getOwnPdfEncoding();
        if (ownPdfEncoding != null) {
            return ownPdfEncoding;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null && (pdfEncoding = baseStyle.getPdfEncoding()) != null) {
            return pdfEncoding;
        }
        return this.propertiesUtil.getProperty("net.sf.jasperreports.default.pdf.encoding");
    }

    public boolean isPdfEmbedded(JRFont font) {
        Boolean pdfEmbedded;
        Boolean ownPdfEmbedded = font.isOwnPdfEmbedded();
        if (ownPdfEmbedded != null) {
            return ownPdfEmbedded;
        }
        JRStyle baseStyle = this.getBaseStyle(font);
        if (baseStyle != null && (pdfEmbedded = baseStyle.isPdfEmbedded()) != null) {
            return pdfEmbedded;
        }
        return this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.default.pdf.embedded");
    }

    public Boolean isPdfEmbedded(JRStyle style) {
        Boolean ownPdfEmbedded = style.isOwnPdfEmbedded();
        if (ownPdfEmbedded != null) {
            return ownPdfEmbedded;
        }
        JRStyle baseStyle = this.getBaseStyle(style);
        if (baseStyle != null) {
            return baseStyle.isPdfEmbedded();
        }
        return null;
    }

    public Integer getPadding(JRLineBox box) {
        Integer padding;
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle baseStyle = this.getBaseStyle(box);
        if (baseStyle != null && (padding = baseStyle.getLineBox().getPadding()) != null) {
            return padding;
        }
        return INTEGER_ZERO;
    }

    public Integer getTopPadding(JRLineBox box) {
        Integer topPadding;
        Integer ownTopPadding = box.getOwnTopPadding();
        if (ownTopPadding != null) {
            return ownTopPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle(box);
        if (style != null && (topPadding = style.getLineBox().getTopPadding()) != null) {
            return topPadding;
        }
        return INTEGER_ZERO;
    }

    public Integer getLeftPadding(JRLineBox box) {
        Integer leftPadding;
        Integer ownLeftPadding = box.getOwnLeftPadding();
        if (ownLeftPadding != null) {
            return ownLeftPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle(box);
        if (style != null && (leftPadding = style.getLineBox().getLeftPadding()) != null) {
            return leftPadding;
        }
        return INTEGER_ZERO;
    }

    public Integer getBottomPadding(JRLineBox box) {
        Integer bottomPadding;
        Integer ownBottomPadding = box.getOwnBottomPadding();
        if (ownBottomPadding != null) {
            return ownBottomPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle(box);
        if (style != null && (bottomPadding = style.getLineBox().getBottomPadding()) != null) {
            return bottomPadding;
        }
        return INTEGER_ZERO;
    }

    public Integer getRightPadding(JRLineBox box) {
        Integer rightPadding;
        Integer ownRightPadding = box.getOwnRightPadding();
        if (ownRightPadding != null) {
            return ownRightPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle(box);
        if (style != null && (rightPadding = style.getLineBox().getRightPadding()) != null) {
            return rightPadding;
        }
        return INTEGER_ZERO;
    }
}

