/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.Validation;
import jakarta.validation.metadata.Scope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.job.ConstraintValidators;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.tomee.microprofile.jwt.bval.MethodConstraints;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class ClassValidationData {
    private final Class<?> clazz;
    private final List<MethodConstraints> jwtConstraints = new ArrayList<MethodConstraints>();
    private final List<MethodConstraints> returnConstraints = new ArrayList<MethodConstraints>();

    public ClassValidationData(Class<?> clazz) {
        this.clazz = clazz;
        ConstraintValidators validators = new ConstraintValidators();
        ApacheValidatorFactory factory = (ApacheValidatorFactory)ApacheValidatorFactory.class.cast(Validation.buildDefaultValidatorFactory());
        for (Method method : clazz.getMethods()) {
            List<ConstraintD<?>> constraints = ClassValidationData.getConstraints(factory, method);
            if (constraints.size() == 0) continue;
            MethodConstraints jwtAnnotations = new MethodConstraints(method);
            MethodConstraints returnAnnotations = new MethodConstraints(method);
            if (method.getReturnType().isAssignableFrom(JsonWebToken.class)) {
                for (ConstraintD<?> constraint : constraints) {
                    returnAnnotations.add(constraint);
                }
            } else {
                for (ConstraintD<?> constraint : constraints) {
                    if (validators.canValidate(constraint, JsonWebToken.class)) {
                        jwtAnnotations.add(constraint);
                        continue;
                    }
                    returnAnnotations.add(constraint);
                }
            }
            if (jwtAnnotations.getAnnotations().size() > 0) {
                this.jwtConstraints.add(jwtAnnotations);
            }
            if (returnAnnotations.getAnnotations().size() <= 0) continue;
            this.returnConstraints.add(returnAnnotations);
        }
    }

    private static List<ConstraintD<?>> getConstraints(ApacheValidatorFactory factory, Method method) {
        ArrayList constraints = new ArrayList();
        Meta.ForMethod meta = new Meta.ForMethod(method);
        for (Annotation annotation : method.getAnnotations()) {
            try {
                ConstraintD constraint = new ConstraintD(annotation, Scope.LOCAL_ELEMENT, (Meta)meta, factory);
                constraints.add(constraint);
            }
            catch (ConstraintDefinitionException constraintDefinitionException) {
                // empty catch block
            }
        }
        return constraints;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<MethodConstraints> getJwtConstraints() {
        return this.jwtConstraints;
    }

    public List<MethodConstraints> getReturnConstraints() {
        return this.returnConstraints;
    }
}

