/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverterOptimised;
import org.apache.camel.converter.NIOConverterOptimised;
import org.apache.camel.converter.ObjectConverterOptimised;
import org.apache.camel.converter.TimePatternConverterOptimised;
import org.apache.camel.impl.converter.EnumTypeConverter;

public class OptimisedTypeConverter {
    private final EnumTypeConverter enumTypeConverter = new EnumTypeConverter();

    public Object convertTo(Class<?> type, Exchange exchange, Object value) throws Exception {
        Object answer = TimePatternConverterOptimised.convertTo(type, exchange, value);
        if (answer == null) {
            answer = ObjectConverterOptimised.convertTo(type, exchange, value);
        }
        if (answer == null) {
            answer = IOConverterOptimised.convertTo(type, exchange, value);
        }
        if (answer == null) {
            answer = NIOConverterOptimised.convertTo(type, exchange, value);
        }
        if (answer == null && type.isEnum()) {
            answer = this.enumTypeConverter.convertTo(type, exchange, value);
        }
        return answer;
    }
}

