/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class DistanceFeatureQueryBase<TOrigin, TDistance>
extends QueryBase {
    private final TOrigin origin;
    private final TDistance pivot;
    private final String field;
    @Nullable
    private final JsonpSerializer<TOrigin> tOriginSerializer;
    @Nullable
    private final JsonpSerializer<TDistance> tDistanceSerializer;

    protected DistanceFeatureQueryBase(AbstractBuilder<TOrigin, TDistance, ?> builder) {
        super(builder);
        this.origin = ApiTypeHelper.requireNonNull(builder.origin, this, "origin");
        this.pivot = ApiTypeHelper.requireNonNull(builder.pivot, this, "pivot");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.tOriginSerializer = builder.tOriginSerializer;
        this.tDistanceSerializer = builder.tDistanceSerializer;
    }

    public final TOrigin origin() {
        return this.origin;
    }

    public final TDistance pivot() {
        return this.pivot;
    }

    public final String field() {
        return this.field;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("origin");
        JsonpUtils.serialize(this.origin, (JsonGenerator)generator, this.tOriginSerializer, (JsonpMapper)mapper);
        generator.writeKey("pivot");
        JsonpUtils.serialize(this.pivot, (JsonGenerator)generator, this.tDistanceSerializer, (JsonpMapper)mapper);
        generator.writeKey("field");
        generator.write(this.field);
    }

    protected static <TOrigin, TDistance, BuilderT extends AbstractBuilder<TOrigin, TDistance, BuilderT>> void setupDistanceFeatureQueryBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TOrigin> tOriginDeserializer, JsonpDeserializer<TDistance> tDistanceDeserializer) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(AbstractBuilder::origin, tOriginDeserializer, "origin");
        op.add(AbstractBuilder::pivot, tDistanceDeserializer, "pivot");
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field");
    }

    public static abstract class AbstractBuilder<TOrigin, TDistance, BuilderT extends AbstractBuilder<TOrigin, TDistance, BuilderT>>
    extends QueryBase.AbstractBuilder<BuilderT> {
        private TOrigin origin;
        private TDistance pivot;
        private String field;
        @Nullable
        private JsonpSerializer<TOrigin> tOriginSerializer;
        @Nullable
        private JsonpSerializer<TDistance> tDistanceSerializer;

        public final BuilderT origin(TOrigin value) {
            this.origin = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT pivot(TDistance value) {
            this.pivot = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT field(String value) {
            this.field = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT tOriginSerializer(@Nullable JsonpSerializer<TOrigin> value) {
            this.tOriginSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT tDistanceSerializer(@Nullable JsonpSerializer<TDistance> value) {
            this.tDistanceSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

