/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class FeedbackPanel
extends Panel
implements IFeedback {
    private static final long serialVersionUID = 1L;
    private final MessageListView messageListView;

    public FeedbackPanel(String id) {
        this(id, (IFeedbackMessageFilter)null);
    }

    public FeedbackPanel(String id, IFeedbackMessageFilter filter) {
        super(id);
        WebMarkupContainer messagesContainer = new WebMarkupContainer("feedbackul"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(FeedbackPanel.this.anyMessage());
            }
        };
        this.add(messagesContainer);
        this.messageListView = new MessageListView("messages");
        this.messageListView.setVersioned(false);
        messagesContainer.add(this.messageListView);
        if (filter != null) {
            this.setFilter(filter);
        }
    }

    public final boolean anyErrorMessage() {
        return this.anyMessage(400);
    }

    public final boolean anyMessage() {
        return this.anyMessage(0);
    }

    public final boolean anyMessage(int level) {
        List<FeedbackMessage> msgs = this.getCurrentMessages();
        for (FeedbackMessage msg : msgs) {
            if (!msg.isLevel(level)) continue;
            return true;
        }
        return false;
    }

    public final FeedbackMessagesModel getFeedbackMessagesModel() {
        return (FeedbackMessagesModel)this.messageListView.getDefaultModel();
    }

    public final IFeedbackMessageFilter getFilter() {
        return this.getFeedbackMessagesModel().getFilter();
    }

    public final Comparator<FeedbackMessage> getSortingComparator() {
        return this.getFeedbackMessagesModel().getSortingComparator();
    }

    @Override
    public boolean isVersioned() {
        return false;
    }

    public final FeedbackPanel setFilter(IFeedbackMessageFilter filter) {
        this.getFeedbackMessagesModel().setFilter(filter);
        return this;
    }

    public final FeedbackPanel setMaxMessages(int maxMessages) {
        this.messageListView.setViewSize(maxMessages);
        return this;
    }

    public final FeedbackPanel setSortingComparator(Comparator<FeedbackMessage> sortingComparator) {
        this.getFeedbackMessagesModel().setSortingComparator(sortingComparator);
        return this;
    }

    protected String getCSSClass(FeedbackMessage message) {
        return switch (message.getLevel()) {
            case 0 -> this.getString(FeedbackMessage.UNDEFINED_CSS_CLASS_KEY);
            case 100 -> this.getString(FeedbackMessage.DEBUG_CSS_CLASS_KEY);
            case 200 -> this.getString(FeedbackMessage.INFO_CSS_CLASS_KEY);
            case 250 -> this.getString(FeedbackMessage.SUCCESS_CSS_CLASS_KEY);
            case 300 -> this.getString(FeedbackMessage.WARNING_CSS_CLASS_KEY);
            case 400 -> this.getString(FeedbackMessage.ERROR_CSS_CLASS_KEY);
            case 500 -> this.getString(FeedbackMessage.FATAL_CSS_CLASS_KEY);
            default -> "feedbackPanel" + message.getLevelAsString();
        };
    }

    protected final List<FeedbackMessage> getCurrentMessages() {
        List messages = this.messageListView.getModelObject();
        return Collections.unmodifiableList(messages);
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        return new FeedbackMessagesModel(this);
    }

    protected Component newMessageDisplayComponent(String id, FeedbackMessage message) {
        Serializable rawMessage = message.getMessage();
        Label label = new Label(id, rawMessage);
        label.setEscapeModelStrings(this.getEscapeModelStrings());
        return label;
    }

    protected ListItem<FeedbackMessage> newMessageItem(int index, IModel<FeedbackMessage> itemModel) {
        return new ListItem<FeedbackMessage>(index, itemModel);
    }

    private final class MessageListView
    extends ListView<FeedbackMessage> {
        private static final long serialVersionUID = 1L;

        public MessageListView(String id) {
            super(id);
            this.setDefaultModel((IModel)FeedbackPanel.this.newFeedbackMessagesModel());
        }

        @Override
        protected IModel<FeedbackMessage> getListItemModel(final IModel<? extends List<FeedbackMessage>> listViewModel, final int index) {
            return new IModel<FeedbackMessage>(){
                private static final long serialVersionUID = 1L;

                @Override
                public FeedbackMessage getObject() {
                    if (index >= ((List)listViewModel.getObject()).size()) {
                        return null;
                    }
                    return (FeedbackMessage)((List)listViewModel.getObject()).get(index);
                }
            };
        }

        @Override
        protected void populateItem(ListItem<FeedbackMessage> listItem) {
            FeedbackMessage message = (FeedbackMessage)listItem.getModelObject();
            message.markRendered();
            Component label = FeedbackPanel.this.newMessageDisplayComponent("message", message);
            AttributeAppender levelModifier = AttributeModifier.append("class", (Serializable)((Object)FeedbackPanel.this.getCSSClass(message)));
            listItem.add(levelModifier);
            listItem.add(label);
        }

        @Override
        protected ListItem<FeedbackMessage> newItem(int index, IModel<FeedbackMessage> itemModel) {
            return FeedbackPanel.this.newMessageItem(index, itemModel);
        }
    }
}

