/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.wicket.markup.html.PackageResourceGuard;
import org.apache.wicket.util.collections.ReverseListIterator;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurePackageResourceGuard
extends PackageResourceGuard {
    private static final Logger log = LoggerFactory.getLogger(SecurePackageResourceGuard.class);
    private static final char PATH_SEPARATOR = '/';
    private List<SearchPattern> pattern = new ArrayList<SearchPattern>();
    private final ConcurrentMap<String, Boolean> cache;

    public SecurePackageResourceGuard() {
        this(new SimpleCache(100));
    }

    public SecurePackageResourceGuard(ConcurrentMap<String, Boolean> cache) {
        this.cache = cache;
        this.addPattern("+*.js");
        this.addPattern("+*.css");
        this.addPattern("+*.png");
        this.addPattern("+*.jpg");
        this.addPattern("+*.jpeg");
        this.addPattern("+*.gif");
        this.addPattern("+*.ico");
        this.addPattern("+*.cur");
        this.addPattern("+*.map");
        this.addPattern("+*.html");
        this.addPattern("+*.txt");
        this.addPattern("+*.swf");
        this.addPattern("+*.bmp");
        this.addPattern("+*.svg");
        this.addPattern("+*.avif");
        this.addPattern("+*.eot");
        this.addPattern("+*.ttf");
        this.addPattern("+*.woff");
        this.addPattern("+*.woff2");
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public boolean accept(String path) {
        Boolean rtn;
        if (this.cache != null && (rtn = (Boolean)this.cache.get(path)) != null) {
            return rtn;
        }
        if (!super.accept(path)) {
            return false;
        }
        boolean hit = false;
        for (SearchPattern pattern : new ReverseListIterator(this.pattern)) {
            if (pattern == null || !pattern.isActive() || !pattern.matches(path)) continue;
            hit = pattern.isInclude();
            break;
        }
        if (this.cache != null) {
            this.cache.put(path, hit ? Boolean.TRUE : Boolean.FALSE);
        }
        if (!hit) {
            log.warn("Access denied to shared (static) resource: " + path);
        }
        return hit;
    }

    public List<SearchPattern> getPattern() {
        this.clearCache();
        return this.pattern;
    }

    public void setPattern(List<SearchPattern> pattern) {
        this.pattern = pattern;
        this.clearCache();
    }

    public void addPattern(String pattern) {
        this.pattern.add(new SearchPattern(pattern));
        this.clearCache();
    }

    public static class SimpleCache
    extends ConcurrentHashMap<String, Boolean> {
        private static final long serialVersionUID = 1L;
        private final ConcurrentLinkedQueue<String> fifo = new ConcurrentLinkedQueue();
        private final int maxSize;

        public SimpleCache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public Boolean put(String key, Boolean value) {
            Boolean rtn = super.putIfAbsent(key, value);
            if (rtn != null) {
                this.fifo.remove(key);
            }
            this.fifo.add(key);
            while (this.fifo.size() > this.maxSize) {
                this.remove(this.fifo.poll());
            }
            return rtn;
        }
    }

    public static class SearchPattern {
        private String pattern;
        private Pattern regex;
        private boolean include;
        private boolean active = true;
        private boolean fileOnly;

        public SearchPattern(String pattern) {
            this.setPattern(pattern);
        }

        private Pattern convertToRegex(String pattern) {
            String regex = Strings.replaceAll((CharSequence)pattern, (CharSequence)".", (CharSequence)"#dot#").toString();
            regex = regex.replaceAll("^\\*/", "[^/]+/");
            regex = regex.replaceAll("^[\\*]{2,}/", "([^/].#star#/)?");
            regex = regex.replaceAll("/\\*/", "/[^/]+/");
            regex = regex.replaceAll("/[\\*]{2,}/", "(/|/.+/)");
            regex = regex.replaceAll("\\*+", "[^/]*");
            regex = Strings.replaceAll((CharSequence)regex, (CharSequence)"#dot#", (CharSequence)"\\.").toString();
            regex = Strings.replaceAll((CharSequence)regex, (CharSequence)"#star#", (CharSequence)"*").toString();
            return Pattern.compile(regex);
        }

        public String getPattern() {
            return this.pattern;
        }

        public Pattern getRegex() {
            return this.regex;
        }

        public void setPattern(String pattern) {
            if (Strings.isEmpty((String)pattern)) {
                throw new IllegalArgumentException("Parameter 'pattern' can not be null or an empty string");
            }
            if (pattern.charAt(0) == '+') {
                this.include = true;
            } else if (pattern.charAt(0) == '-') {
                this.include = false;
            } else {
                throw new IllegalArgumentException("Parameter 'pattern' must start with either '+' or '-'. pattern='" + pattern + "'");
            }
            this.pattern = pattern;
            this.regex = this.convertToRegex(pattern.substring(1));
            this.fileOnly = pattern.indexOf(47) == -1;
        }

        public boolean matches(String path) {
            if (this.fileOnly) {
                path = Strings.lastPathComponent((String)path, (char)'/');
            }
            return this.regex.matcher(path).matches();
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public String toString() {
            return "Pattern: " + this.pattern + ", Regex: " + String.valueOf(this.regex) + ", include:" + this.include + ", fileOnly:" + this.fileOnly + ", active:" + this.active;
        }
    }
}

